package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.facade.param.AppVersionParam;
import com.bxm.fossicker.base.facade.vo.AppChannelVersionVO;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.AppVersionService;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @authoer Gonzo
 * @date 2019-09-03 10:19
 *
 * 版本升级弹窗：每次启动时检查新版本，若有新版本则弹，一天一次
 */
@PopUpProcess(special = PopUpEnum.HOME_VERSION, order = PopUpProcessOrderEn.CUSTOM)
public class VersionPopUpWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private AppVersionService appVersionService;

    private static final String VERSION = "VERSION";

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 判断是否有新版本
        AppVersionParam param = new AppVersionParam();
        BeanUtils.copyProperties(popUpWindows.getParam(), param);

        AppChannelVersionVO appChannelVersionVO = appVersionService.getVersion(param);

        if (null != appChannelVersionVO) {
            // 如果有新版本，则弹出
            // 次数在通用处理器做了
            popUpWindows.getParams().put(VERSION, appChannelVersionVO);
            return;
        }

        // 移除版本升级弹窗
        remove(popUpWindows, PopUpEnum.HOME_VERSION);

    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {

        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> {
                AppChannelVersionVO appChannelVersionVO = popUpWindows.getParam(VERSION);

                if (Objects.isNull(appChannelVersionVO)) {
                    // 添加版本信息
                    AppVersionParam param = new AppVersionParam();
                    BeanUtils.copyProperties(popUpWindows.getParam(), param);

                    appChannelVersionVO = appVersionService.getVersion(param);
                }

                if (!Objects.isNull(appChannelVersionVO)) {
                    p.setExt(JSON.toJSONString(appChannelVersionVO));
                }
            });
        }

    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录版本升级弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}
