package com.bxm.fossicker.base.service.impl.popup.process.lottery.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.LotteryFacadeService;
import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 全名大抽奖首页
 * @Author: Gonzo
 * @Date 2020-02-11 19:16
 * @since 1.5.0
 */
@PopUpProcess(special = PopUpEnum.LOTTERY_HOME, order = PopUpProcessOrderEn.CUSTOM)
public class LotteryHomepageWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private LotteryFacadeService lotteryFacadeService;


    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        // 获取当前处理弹窗
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            // 查询活动列表中的第一个活动
            LotteryDTO topLottery = lotteryFacadeService.getTopLottery();

            commonPopUpWindowsEntryList.forEach(p -> {
                if (null != topLottery) {
                    p.setExt(JSON.toJSONString(topLottery));
                }
            });
        }
    }


    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录 全名大抽奖首页 弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }


    @Data
    public class LotteryHomepageExt {

        /**
         * 活动id
         */
        private Long lotteryId;
    }
}
