package com.bxm.fossicker.base.service.impl.popup.process.mine;

import com.bxm.fossicker.activity.facade.SignFacadeService;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Objects;

/**
 * @authoer Gonzo
 * @date 2019-09-03 12:23
 *
 * 邀请弹窗：用户启动应用后，点击“我的”，若用户当日已签到，则弹出弹窗。每天只弹一次。
 * @deprecated
 */
@PopUpProcess(special = PopUpEnum.MINE_INVITE,order = PopUpProcessOrderEn.CUSTOM)
public class InviteUserPopUpWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private SignFacadeService signFacadeService;


    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        // 邀请好友未弹过,若签到弹窗未弹-邀请好友也不弹窗
        // 这个逻辑改为：如果有签到弹窗则不弹。如果没有签到弹窗则弹，（也就是相斥逻辑）
        // 因为签到弹窗会自动签到，所以也不需要判断是否签到

    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录邀请弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }

}
