package com.bxm.fossicker.base.service.impl.popup.process.mine;

import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.model.TreasureBoxFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Objects;

/**
 * 宝箱弹窗
 * 该任务未完成时一天最多弹一次
 * @authoer Gonzo
 * @date 2019-09-03 12:00
 */
@PopUpProcess(special = PopUpEnum.MINE_TREASURE_BOX, order = PopUpProcessOrderEn.CUSTOM)
public class TreasureBoxWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private ActivityFacadeService activityFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        TreasureBoxFacadeDTO treasureBoxFacadeDTO = activityFacadeService.treasureBox(popUpWindows.getParam().getUserId());

        if (Objects.isNull(treasureBoxFacadeDTO) && Objects.equals(treasureBoxFacadeDTO.getStatus(), 0)) {
            // 未开启，则弹窗弹窗
            return;
        }

        // 否则移除弹窗
        remove(popUpWindows, PopUpEnum.TASK_TAOBAO_SEARCH);
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录宝箱弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));

    }
}
