package com.bxm.fossicker.base.service.impl.popup.process.order;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.order.facade.service.OrderFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 订单跟单拦截弹窗
 * @author =xujl
 * @date 2019年11月20日
 */
@Slf4j
@PopUpProcess(special = PopUpEnum.ORDER_FOLLOW_SUCCESS,order = PopUpProcessOrderEn.CUSTOM)
public class OrderFollowProcess extends AbstractPopUpWindowsProcess{

    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private OrderFacadeService orderFacadeService;

    private String EXT_KEY = "orderfollowsuccess";

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        KeyGenerator keyGenerator = UserRedisKeyConstant.USER_HAS_NEW_FOLLOW_ORDER.copy().setKey(popUpWindows.getParam().getUserId()+"");
        List<String> orderIds = redisListAdapter.range(keyGenerator,0,-1,String.class);
        if(orderIds.size() > 0){
            String info = orderFacadeService.getOrdersInfo(popUpWindows.getParam().getUserId(),orderIds);
            if(null != info){
                popUpWindows.put(EXT_KEY,info);
                redisListAdapter.remove(keyGenerator);
            }else{
                remove(popUpWindows,PopUpEnum.ORDER_FOLLOW_SUCCESS);
            }
        }else{
            remove(popUpWindows,PopUpEnum.ORDER_FOLLOW_SUCCESS);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
     /*   Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录新人引导弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));*/
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        // 设置红包信息
        String info  = popUpWindows.getParam(EXT_KEY);
        if (StringUtils.isNotEmpty(info)) {
            List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);
            JSONObject jsonObject = JSONObject.parseObject(info);
            if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
                commonPopUpWindowsEntryList.stream().forEach(p -> {
                    // 添加弹窗信息 - 今日可领取金币数
                    p.setExt(p.getMaterialExt().replace("{num}",jsonObject.getString("num"))
                            .replace("{totalAmount}",jsonObject.getString("totalAmount"))
                            .replace("{shareUserId}",popUpWindows.getParam().getUserId()+""));
                });
            }
        }
    }

    public static void main(String[] args) {
        String info ="{\"num\":1,\"totalAmount\":2}";
        JSONObject j = JSONObject.parseObject(info);
        System.out.println(j.getString("num"));
    }
}
