package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.activity.facade.model.ActivityUserTaskFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.commodity.facade.CommodityFacadeService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 首次浏览商品
 * @authoer Gonzo
 * @date 2019-09-03 12:00
 */
@PopUpProcess(special = PopUpEnum.TASK_FIRST_BROWSE, order = PopUpProcessOrderEn.CUSTOM)
public class FirstBrowseWindowsProcess extends AbstractPopUpWindowsProcess {


    @Autowired
    private TaskFacadeService taskFacadeService;

    @Autowired
    private CommodityFacadeService commodityFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        ActivityUserTaskFacadeDTO activityUserTaskFacadeDTO = taskFacadeService.queryUserTask(popUpWindows.getParam().getUserId(), ActivityFacadeEnum.VIEW_GOODS);

        if (Objects.nonNull(activityUserTaskFacadeDTO) && activityUserTaskFacadeDTO.getStatus() == 0) {
            // 获取淘宝授权的弹窗id
            Long popId = getPopIdByType(PopUpEnum.TASK_TAOBAO_AUTH.getType());

            // 判断淘宝授权弹窗是否弹过，并且不是今日弹的
            UserPopUpedBO userPopUpedBO = popUpWindows.getPopUpedInfo().get(Objects.toString(popId));
            if (Objects.nonNull(userPopUpedBO)) {

                // 淘宝授权是否已经弹过
                if (Objects.nonNull(userPopUpedBO.getFinalClose()) && userPopUpedBO.getFinalClose()) {

                    // 不是今天弹出的
                    if ((Objects.nonNull(userPopUpedBO.getDay()) && !DateUtils.isSameDay(userPopUpedBO.getDay(), new Date()))
                            // 或者是今天弹出的但是此时其实为0（也就是今天其实没有弹出，直接永久关闭了）
                            || (Objects.nonNull(userPopUpedBO.getDay()) && DateUtils.isSameDay(userPopUpedBO.getDay(), new Date())
                            && Objects.nonNull(userPopUpedBO.getTimes()) && userPopUpedBO.getTimes() == 0)) {
                        // 满足条件，弹出
                        return;
                    }
                }
            }

            // 否则移除，等待淘宝授权弹出过后再弹
            remove(popUpWindows, PopUpEnum.TASK_FIRST_BROWSE);

            if (log.isDebugEnabled()) {
                log.debug("首次浏览商品过滤器，过滤首次浏览商品弹窗");
            }
        }

        // 否则就是已完成，永久关闭弹窗 不添加弹出次数
        autoClose(popUpWindows, Boolean.TRUE, 0);
        // 移除弹窗
        remove(popUpWindows, PopUpEnum.TASK_FIRST_BROWSE);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {

            // 跳转链接改为精选列表的第一个商品
            Long commodityId = commodityFacadeService.getWellChoseFirstCommodityId(popUpWindows.getParam().getUserId());

            // 跳转链接，放到配置中
            String jumpUrl = "qtj://goods/goodsDetail?goodsId=";
            if (Objects.nonNull(commodityId)) {
                jumpUrl = StringUtils.join(jumpUrl, commodityId);
            }

            String fJump = jumpUrl;

            commonPopUpWindowsEntryList.stream().forEach(p -> {
                // 添加弹窗信息 - 可领取金币
                p.setExt(p.getMaterialExt());

                // 跳转链接
                p.setJumpUrl(fJump);
            });
        }

    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录新人教程弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));

    }
}
