package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.model.DayGoldFacadeDto;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 新人7日红包弹窗
 * 点击任务tab，若当日有待领取的新人红包则弹出此弹窗。
 * @authoer Gonzo
 * @date 2019-09-03 12:00
 */
@PopUpProcess(special = PopUpEnum.TASK_NOVICE_SEVEN, order = PopUpProcessOrderEn.CUSTOM)
public class NoviceSevenWindowsProcess extends AbstractPopUpWindowsProcess {


    @Autowired
    private UserInfoFacadeService userInfoFacadeService;

    @Autowired
    private TaskFacadeService taskFacadeService;


    public static final String DAY_GOLD_FACADE_DTO = "DAY_GOLD_FACADE_DTO";


    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        DayGoldFacadeDto dayGoldFacadeDto = taskFacadeService.dayGoldInfo(popUpWindows.getParam().getUserId());

        // 如果没有红包信息则表示已经结束
        if (Objects.isNull(dayGoldFacadeDto)) {
            // 彻底关闭 不添加弹出次数
            autoClose(popUpWindows, Boolean.TRUE, 0);
            remove(popUpWindows, PopUpEnum.TASK_NOVICE_SEVEN);
            return ;
        }

        // 今日未领取
        if (dayGoldFacadeDto.getUnObtain()) {
            // 增加弹窗信息
            popUpWindows.getParams().put(DAY_GOLD_FACADE_DTO, dayGoldFacadeDto);
            return;
        }

        // 已领取，但是用户没有点击关闭，自动关闭 增加今日弹出次数
        autoClose(popUpWindows, Boolean.FALSE, 1);
        remove(popUpWindows, PopUpEnum.TASK_NOVICE_SEVEN);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        // 设置红包信息
        DayGoldFacadeDto dayGoldFacadeDto = popUpWindows.getParam(DAY_GOLD_FACADE_DTO);

        if (Objects.nonNull(dayGoldFacadeDto)) {
            List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);


            if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
                commonPopUpWindowsEntryList.stream().forEach(p -> {
                    // 添加弹窗信息 - 今日可领取金币数
                    p.setExt(JSON.toJSONString(dayGoldFacadeDto));
                });
            }
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录新人七天弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}
