package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.SignFacadeService;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;


/**
 * 任务页/我的页面签到弹窗
 * 弹出今天签到所能获取的金额
 *
 * @date 2019-09-03 11:51
 * <p>
 * 签到弹窗:一天弹一次
 */
@PopUpProcess(special = PopUpEnum.TASK_SIGN_AMOUNT, order = PopUpProcessOrderEn.CUSTOM)
public class SignAmountPopUpWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private SignFacadeService signFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 判断是否存在要处理的弹窗
        if (super.preInvoke(popUpWindows)) {
            // 如果当前是我的页面
            if (Objects.equals(popUpWindows.getParam().getPosition().intValue(), 2)) {
                // 版本在是否在1.3.0之上
                if (StringUtils.compareVersion(popUpWindows.getParam().getCurVer(), "1.3.0") >= 0) {
                    // 直接移除
                    remove(popUpWindows, PopUpEnum.TASK_SIGN_AMOUNT);
                    return false;
                }
            }

            // 新的弹窗，1.5.0以下不需要这个弹窗
            if (StringUtils.compareVersion(popUpWindows.getParam().getCurVer(), "1.5.0") < 0) {
                remove(popUpWindows, PopUpEnum.TASK_SIGN_AMOUNT);
                return false;
            }

            return true;
        }

        return false;
    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();

        if (!signFacadeService.didSign(userId, new Date())) {

        } else {
            // 已签到，但是没有点击手动关闭，则自动关闭 增加今日弹出次数
            autoClose(popUpWindows, Boolean.FALSE, 1);
            remove(popUpWindows, PopUpEnum.TASK_SIGN_AMOUNT);
        }
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {

        // 封装签到弹窗数据
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {

            commonPopUpWindowsEntryList.forEach(p -> {
                Integer signReward = signFacadeService.getTodaySignReward(popUpWindows.getParam().getUserId());

                if (!Objects.isNull(signReward)) {
                    p.setExt(JSON.toJSONString(signReward));
                }
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录签到弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}
