package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.SignFacadeService;
import com.bxm.fossicker.activity.facade.model.SignFacadeDto;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;


/**
 * 任务页/我的页面签到弹窗
 * 我的页面是为了做版本兼容，当时没考虑到
 *
 * @date 2019-09-03 11:51
 * <p>
 * 签到弹窗:一天弹一次
 */
@PopUpProcess(special = PopUpEnum.TASK_SIGN, order = PopUpProcessOrderEn.CUSTOM)
public class SignPopUpWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private SignFacadeService signFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {
        // 1.3.0之前，在我的页面也有一个签到弹窗，但是刚开始以为是直接挪过去导致type类型被占用，所以公用一个type这里代码判断

        // 判断是否存在要处理的弹窗
        if (super.preInvoke(popUpWindows)) {
            // 如果当前是我的页面
            if (Objects.equals(popUpWindows.getParam().getPosition().intValue(), 2)) {
                // 版本在是否在1.3.0之上
                if (StringUtils.compareVersion(popUpWindows.getParam().getCurVer(), "1.3.0") >= 0) {
                    // 直接移除
                    remove(popUpWindows, PopUpEnum.TASK_SIGN);
                    return false;
                }
            }

            // 1.5.0开始取消自动签到弹窗
            if (StringUtils.compareVersion(popUpWindows.getParam().getCurVer(), "1.5.0") >= 0) {
                remove(popUpWindows, PopUpEnum.TASK_SIGN);
                return false;
            }

            return true;
        }
        return false;
    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();

        if (!signFacadeService.didSign(userId, new Date())) {
            // 没签到则自动签到
            signFacadeService.signByDay(userId);
        } else {
            // 已签到，但是没有点击手动关闭，则自动关闭 增加今日弹出次数
            autoClose(popUpWindows, Boolean.FALSE, 1);
            remove(popUpWindows, PopUpEnum.TASK_SIGN);
        }
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {

        // 封装签到弹窗数据
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {

            commonPopUpWindowsEntryList.forEach(p -> {
                SignFacadeDto signInfo = signFacadeService.getSignInfo(popUpWindows.getParam().getUserId());

                if (!Objects.isNull(signInfo)) {
                    p.setExt(JSON.toJSONString(signInfo));
                }
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录签到弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}
