package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.activity.facade.model.ActivityUserTaskFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 淘宝授权弹窗
 * @authoer Gonzo
 * @date 2019-09-03 12:00
 */
@PopUpProcess(special = PopUpEnum.TASK_TAOBAO_AUTH, order = PopUpProcessOrderEn.CUSTOM)
public class TaobaoAuthWindowsProcess extends AbstractPopUpWindowsProcess {


    @Autowired
    private TaskFacadeService taskFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        ActivityUserTaskFacadeDTO activityUserTaskFacadeDTO = taskFacadeService.queryUserTask(popUpWindows.getParam().getUserId(), ActivityFacadeEnum.AUTH_TAOBAO);

        if (Objects.nonNull(activityUserTaskFacadeDTO) && activityUserTaskFacadeDTO.getStatus() == 0) {
            // 任务未完成，弹出
            return;
        }

        // 否则就是已完成 永久关闭弹窗
        autoClose(popUpWindows, Boolean.TRUE, 0);
        remove(popUpWindows, PopUpEnum.TASK_TAOBAO_AUTH);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                // 添加弹窗信息 - 可领取金币
                p.setExt(p.getMaterialExt());
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录新人教程弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));

    }
}
