package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.activity.facade.model.ActivityUserTaskFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 搜索淘宝标题弹窗
 * 该任务未完成时一天最多弹一次
 * @authoer Gonzo
 * @date 2019-09-03 12:00
 */
@PopUpProcess(special = PopUpEnum.TASK_TAOBAO_SEARCH, order = PopUpProcessOrderEn.CUSTOM)
public class TaobaoSearchWindowsProcess extends AbstractPopUpWindowsProcess {


    @Autowired
    private TaskFacadeService taskFacadeService;

    @Autowired
    private UserInfoFacadeService userInfoFacadeService;


    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {

        ActivityUserTaskFacadeDTO activityUserTaskFacadeDTO = taskFacadeService.queryUserTask(popUpWindows.getParam().getUserId(), ActivityFacadeEnum.SEARCH_TITLE);

        if (Objects.nonNull(activityUserTaskFacadeDTO) && activityUserTaskFacadeDTO.getStatus() == 0) {

            // 获取首次浏览商品的弹窗id
            Long popId = getPopIdByType(PopUpEnum.TASK_FIRST_BROWSE.getType());

            // 判断首次浏览商品弹窗是否弹过，并且不是今日弹的
            UserPopUpedBO userPopUpedBO = popUpWindows.getPopUpedInfo().get(Objects.toString(popId));
            if (Objects.nonNull(userPopUpedBO)) {

                // 首次浏览商品是否已经弹过
                if (Objects.nonNull(userPopUpedBO.getFinalClose()) && userPopUpedBO.getFinalClose()) {

                    // 不是今天弹出的
                    if ((Objects.nonNull(userPopUpedBO.getDay()) && !DateUtils.isSameDay(userPopUpedBO.getDay(), new Date()))
                            // 或者是今天弹出的但是此时其实为0（也就是今天其实没有弹出，直接永久关闭了）
                            || (Objects.nonNull(userPopUpedBO.getDay()) && DateUtils.isSameDay(userPopUpedBO.getDay(), new Date())
                                    && Objects.nonNull(userPopUpedBO.getTimes()) && userPopUpedBO.getTimes() == 0)) {
                        // 满足条件，弹出
                        return;
                    }
                }
            }

            // 否则移除，等待首次浏览商品弹出过后再弹
            remove(popUpWindows, PopUpEnum.TASK_TAOBAO_SEARCH);

            if (log.isDebugEnabled()) {
                log.debug("搜索淘宝标题过滤器，过滤搜索淘宝标题弹窗");
            }
        }

        // 否则就是已完成 永久关闭弹窗
        autoClose(popUpWindows, Boolean.TRUE, 0);
        remove(popUpWindows, PopUpEnum.TASK_TAOBAO_SEARCH);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);

        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> {
                // 添加弹窗信息 - 可领取金币
                p.setExt(p.getMaterialExt());
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

        Long popId = getPopId(param);

        if (Objects.isNull(popId)) {
            log.warn("未获取到弹窗id，无法记录搜索淘宝标题弹窗弹出, type: {}, popIp: {}", param.getType(), param.getPopUpId());
            return;
        }

        closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));

    }
}
