package com.bxm.fossicker.base.service.impl.popup.process.vipPage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2019/11/25 11:24
 */

/**
 * 成为终身会员弹窗
 * @author =xujl
 * @date 2019年11月20日
 */
@Slf4j
@PopUpProcess(special = PopUpEnum.TOBE_FOREVER_VIP_NOTICE,order = PopUpProcessOrderEn.CUSTOM)
public class TobeForeverVipPopWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private VipFacadeService vipFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 如果当前不是vip页面
        if (!Objects.equals(popUpWindows.getParam().getPosition().intValue(), 5)) {
            return false;
        }
        // 新的弹窗，1.6.0以下不需要这个弹窗
        if (StringUtils.compareVersion(popUpWindows.getParam().getCurVer(), "1.6.0") < 0) {
            remove(popUpWindows, PopUpEnum.TOBE_FOREVER_VIP_NOTICE);
            return false;
        }

        return true;

    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();
        Integer num = vipFacadeService.pushTobeForeverVipContent(userId);
        if (Objects.isNull(num) || num == 0) {
            remove(popUpWindows, PopUpEnum.TOBE_FOREVER_VIP_NOTICE);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        vipFacadeService.removeTobeForeverVipPush(popUpWindows.getParam().getUserId());
    }
}
