package com.bxm.fossicker.base.service.impl.popup.process.vipPage;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.InviteRelationFacadeService;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.user.facade.dto.TobeVipInviteSpeedDto;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 邀请会员进度弹窗
 * @Author: pf.w
 * @Date: 2019/11/25 13:43
 */
@Slf4j
@PopUpProcess(special = PopUpEnum.TOBE_VIP_INVITE_SPEED,order = PopUpProcessOrderEn.CUSTOM)
public class TobeVipForInvitePopWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private InviteRelationFacadeService inviteRelationFacadeService;

    @Autowired
    private VipFacadeService vipFacadeService;

    @Autowired
    private ActivityFacadeService activityFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();
        int num =  inviteRelationFacadeService.getSuccessInvitationInfo(userId);
        if(Objects.isNull(num) || num==0){
            remove(popUpWindows,PopUpEnum.TOBE_VIP_INVITE_SPEED);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);
        Long userId = popUpWindows.getParam().getUserId();
        TobeVipInviteSpeedDto tsd = vipFacadeService.inviteVipEntity(userId);
        tsd.setNum(inviteRelationFacadeService.getSuccessInvitationInfo(userId));
        tsd.setDifferNum(activityFacadeService.differInviteNum(userId));
        tsd.setIsVip(vipFacadeService.isVip(userId));
        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> {
                // 添加弹窗信息 - 可领取金币
                p.setExt(JSONObject.toJSONString(tsd));
            });
        }
        inviteRelationFacadeService.removeSuccessInvitation(userId);
    }
}
