package com.bxm.fossicker.base.service.impl.popup.process.vipPage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2019/11/25 11:24
 */
/**
 * 成为会员弹窗
 * @author =xujl
 * @date 2019年11月20日
 */
@Slf4j
@PopUpProcess(special = PopUpEnum.TOBE_VIP_NOTICE,order = PopUpProcessOrderEn.CUSTOM)
public class TobeVipPopWindowsProcess extends AbstractPopUpWindowsProcess {

    @Autowired
    private VipFacadeService vipFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {

        // 新的弹窗，1.6.0以上不需要这个弹窗
        if (StringUtils.compareVersion(popUpWindows.getParam().getCurVer(), "1.6.0") >= 0) {
            remove(popUpWindows, PopUpEnum.TOBE_VIP_NOTICE);
            return false;
        }

        return true;

    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();
        Integer num =  vipFacadeService.pushTobeVipContent(userId);
        if(Objects.isNull(num) || num==0){
            remove(popUpWindows,PopUpEnum.TOBE_VIP_NOTICE);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {

    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntryList = popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);
        Long userId = popUpWindows.getParam().getUserId();
        if (!CollectionUtils.isEmpty(commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> {
                // 添加弹窗信息 - 可领取金币
                p.setExt(vipFacadeService.pushTobeVipContent(userId).toString());
            });
        }
        vipFacadeService.removeTobeVipPush(userId);
    }
}
