package com.bxm.fossicker.base.utils;

import com.bxm.newidea.component.tools.StringUtils;

/**
 * 设备信息验证工具类
 *
 * @author liujia
 * @date 2020/01/10 15:38
 */
public class EquipmentValidator {

    private final static String[] BLANK_IDFA = {"0000000000000000", "00000000-0000-0000-0000-000000000000"};

    private EquipmentValidator() {

    }

    /**
     * 判断imei是否为正确的格式
     *
     * @param imei 安卓imei号
     * @return true表示格式正确
     */
    public static boolean imei(String imei) {
        if (StringUtils.isBlank(imei)) {
            return false;
        }
        return false;
    }

    /**
     * 判断idfa格式是否正确
     *
     * @param idfa ios idfa
     * @return true表示格式正确
     */
    public static boolean idfa(String idfa) {
        if (StringUtils.isBlank(idfa)) {
            return false;
        }

        for (String blankIdfa : BLANK_IDFA) {
            if (blankIdfa.equals(idfa)) {
                return false;
            }
        }

        return true;
    }
}
