/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.config.BaseInfoPeroperties;
import com.bxm.fossicker.base.param.CommodityShareParam;
import com.bxm.fossicker.base.service.ShortLinkService;
import com.bxm.fossicker.common.constant.BaseRedisKey;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShortLinkServiceImpl
implements ShortLinkService {
    private static final Logger log = LoggerFactory.getLogger(ShortLinkServiceImpl.class);
    private final BaseInfoPeroperties baseInfoPeroperties;
    private static final String REDIRECT = "r";
    private final RedisStringAdapter redisStringAdapter;

    @Autowired
    public ShortLinkServiceImpl(BaseInfoPeroperties baseInfoPeroperties, RedisStringAdapter redisStringAdapter) {
        this.baseInfoPeroperties = baseInfoPeroperties;
        this.redisStringAdapter = redisStringAdapter;
    }

    @Override
    public String getCommodityShareShortLink(CommodityShareParam commodityShareParam) {
        log.debug("\u751f\u6210\u5206\u4eab\u94fe\u63a5\uff0c\u8bf7\u6c42\u53c2\u6570[{}]", (Object)commodityShareParam);
        String shareBaseUrl = this.baseInfoPeroperties.getShareCommodityUrl();
        shareBaseUrl = this.assembleShareCommodityUrl(shareBaseUrl, commodityShareParam);
        return this.getShortUrl(shareBaseUrl, true);
    }

    @Override
    public String getCommodityTicketShortLink(CommodityShareParam commodityShareParam) {
        String shareBaseUrl = this.baseInfoPeroperties.getTicketCommodityUrl();
        shareBaseUrl = this.assembleShareCommodityUrl(shareBaseUrl, commodityShareParam);
        return this.getShortUrl(shareBaseUrl, true);
    }

    @Override
    public String generateShortUrl(String url) {
        return this.getShortUrl(url, true);
    }

    private String assembleShareCommodityUrl(String baseUrl, CommodityShareParam commodityShareParam) {
        StringBuilder stringBuilder = new StringBuilder(baseUrl);
        if (null != commodityShareParam.getGoodsId()) {
            stringBuilder.append("goodsId=").append(commodityShareParam.getGoodsId().toString());
        }
        if (null != commodityShareParam.getShareUserId()) {
            stringBuilder.append("&userId=").append(commodityShareParam.getShareUserId().toString());
        }
        if (null != commodityShareParam.getRelationId()) {
            stringBuilder.append("&relationId=").append(commodityShareParam.getRelationId());
        }
        return stringBuilder.toString();
    }

    private String getShortUrl(String url, boolean expired) {
        log.debug("\u957f\u94fe\u8f6c\u77ed\u94fe\uff0c\u539f\u59cb\u94fe\u63a5\u4e3a[{}]\uff0c\u662f\u5426\u4f1a\u8fc7\u671f[{}]", (Object)url, (Object)expired);
        String shortCode = StringUtils.longToString((long)url.hashCode());
        StringBuilder sortUrl = new StringBuilder();
        sortUrl.append(this.baseInfoPeroperties.getServerHost()).append("/").append(REDIRECT).append("/");
        sortUrl.append(this.getDiffCode(shortCode, url, expired));
        log.debug("\u957f\u94fe\u8f6c\u77ed\u94fe\u5b8c\u6210\uff0c\u539f\u59cb\u94fe\u63a5\u4e3a[{}]\uff0c\u8f6c\u5316\u540e\u7684\u77ed\u94fe\u4e3a[{}]\uff0c\u662f\u5426\u4f1a\u8fc7\u671f[{}]", new Object[]{url, sortUrl, expired});
        return sortUrl.toString();
    }

    private String getDiffCode(String shortCode, String sourceUrl, boolean expired) {
        KeyGenerator shortLinkKey = BaseRedisKey.COMMODITY_SHARE_URL.copy().appendKey((Object)shortCode);
        String cacheUrl = (String)this.redisStringAdapter.get(shortLinkKey, String.class);
        if (null != cacheUrl) {
            if (StringUtils.equals((CharSequence)cacheUrl, (CharSequence)sourceUrl)) {
                return shortCode;
            }
            log.info("\u77ed\u94fe\u5df2\u7ecf\u5b58\u5728\uff0c\u77ed\u94fe\u7f16\u7801:[{}],\u7f13\u5b58\u94fe\u63a5:[{}],\u539f\u59cb\u94fe\u63a5:[{}]", new Object[]{shortCode, cacheUrl, sourceUrl});
            return this.getDiffCode(shortCode + "1", sourceUrl, expired);
        }
        if (expired) {
            this.redisStringAdapter.set(shortLinkKey, (Object)sourceUrl, 2592000L);
        } else {
            this.redisStringAdapter.set(shortLinkKey, (Object)sourceUrl);
        }
        return shortCode;
    }
}

