/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.constant.PopUpRedisConstant;
import com.bxm.fossicker.base.domain.CommonPopUpWindowsMapper;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.param.PopUpWindowsClickParam;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.param.PopUpWindowsListParam;
import com.bxm.fossicker.base.service.PopUpWindowsService;
import com.bxm.fossicker.base.service.impl.popup.PopUpWindowsInterceptorChain;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.interfacies.ClosePopUp;
import com.bxm.fossicker.base.vo.PopUpWindowsVO;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class PopUpWindowsServiceImpl
implements PopUpWindowsService {
    private static final Logger log = LoggerFactory.getLogger(PopUpWindowsServiceImpl.class);
    @Resource
    private PopUpWindowsInterceptorChain interceptorChain;
    @Resource
    private CommonPopUpWindowsMapper commonPopUpWindowsMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    private static final Map<PopUpEnum, ClosePopUp> CLOSE_POP_UP_MAP = Maps.newHashMap();

    @Override
    public List<PopUpWindowsVO> list(PopUpWindowsListParam param) {
        List<CommonPopUpWindowsEntry> commonPopUpWindowsEntries = this.loadPopUpWindowsCache(param.getPosition());
        String token = (String)this.redisHashMapAdapter.get(UserRedisKeyConstant.HASH_USER_TOKEN, Objects.toString(param.getUserId()), String.class);
        KeyGenerator key = PopUpRedisConstant.USER_POPUP_CACHE.copy().appendKey((Object)Objects.toString(StringUtils.isBlank((CharSequence)token) ? StringUtils.join((Object[])new String[]{"DEVICE_", param.getDevcId()}) : param.getUserId()));
        List userPopUpEds = this.redisHashMapAdapter.values(key, UserPopUpedBO.class);
        Map<Object, Object> popUpEdInfo = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)userPopUpEds)) {
            popUpEdInfo = userPopUpEds.stream().collect(Collectors.toMap(p -> Objects.toString(p.getPopUpId()), p -> p));
        }
        this.interceptorChain.invoke(FilterPopUpWindowsBO.builder().param(param).popUpWindows(commonPopUpWindowsEntries).popUpedInfo((Map)popUpEdInfo).build());
        this.redisHashMapAdapter.putAll(key, (Map)popUpEdInfo);
        return commonPopUpWindowsEntries.stream().map(this::convert).collect(Collectors.toList());
    }

    private List<CommonPopUpWindowsEntry> loadPopUpWindowsCache(Byte position) {
        List commonPopUpWindowsEntries;
        String cacheStr = (String)this.redisHashMapAdapter.get(PopUpRedisConstant.POP_UP_POSITION_CACHE, Objects.toString(position), String.class);
        if (StringUtils.isBlank((CharSequence)cacheStr)) {
            commonPopUpWindowsEntries = this.commonPopUpWindowsMapper.selectByPositionAndPlatform((int)position.byteValue());
            this.redisHashMapAdapter.put(PopUpRedisConstant.POP_UP_POSITION_CACHE, Objects.toString(position), (Object)JSON.toJSONString((Object)commonPopUpWindowsEntries));
        } else {
            commonPopUpWindowsEntries = JSON.parseArray((String)cacheStr, CommonPopUpWindowsEntry.class);
        }
        return commonPopUpWindowsEntries;
    }

    private PopUpWindowsVO convert(CommonPopUpWindowsEntry commonPopUpWindowsEntry) {
        return PopUpWindowsVO.builder().id(commonPopUpWindowsEntry.getId()).name(commonPopUpWindowsEntry.getName()).type(commonPopUpWindowsEntry.getType()).url(commonPopUpWindowsEntry.getJumpUrl()).imgUrl(commonPopUpWindowsEntry.getImgUrl()).width(commonPopUpWindowsEntry.getWidth()).height(commonPopUpWindowsEntry.getHeight()).ext(commonPopUpWindowsEntry.getExt()).build();
    }

    @Override
    public Message close(@RequestBody PopUpWindowsCloseParam param) {
        if (Objects.isNull(param.getType())) {
            log.warn("type \u4e3a\u7a7a");
            return Message.build();
        }
        PopUpEnum byType = PopUpEnum.getByType((byte)param.getType());
        if (Objects.isNull(byType)) {
            if (log.isDebugEnabled()) {
                log.debug("type: {} \u5c5e\u4e8e\u672a\u5b9a\u4e49\u7684\u5f39\u7a97\u5173\u95ed\u7c7b\u578b", (Object)param.getType());
            }
            return Message.build();
        }
        ClosePopUp closePopUp = CLOSE_POP_UP_MAP.get(byType);
        if (Objects.isNull(closePopUp)) {
            log.warn("type: {} \u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94\u7684\u5904\u7406\u5173\u95ed\u7c7b", (Object)param.getType());
            return Message.build();
        }
        closePopUp.close(param);
        return Message.build();
    }

    @Override
    public Message click(@RequestBody PopUpWindowsClickParam param) {
        return Message.build();
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onApplicationStartedEvent(ContextRefreshedEvent event) {
        Collection closePopUps = event.getApplicationContext().getBeansOfType(ClosePopUp.class).values();
        closePopUps.forEach(p -> {
            PopUpProcess popUpProcess = (PopUpProcess)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p), PopUpProcess.class);
            if (Objects.nonNull(popUpProcess) && !Objects.equals(popUpProcess.special(), PopUpEnum.NONE)) {
                CLOSE_POP_UP_MAP.put(popUpProcess.special(), (ClosePopUp)p);
            }
        });
    }
}

