/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.bxm.fossicker.activity.facade.SignFacadeService;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@PopUpProcess(special=PopUpEnum.HOME_SIGN_GUIDE, order=PopUpProcessOrderEn.CUSTOM)
public class SignGuidePopUpProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private SignFacadeService signFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        if (this.signFacadeService.didSign(popUpWindows.getParam().getUserId(), new Date()).booleanValue()) {
            this.autoClose(popUpWindows, Boolean.FALSE, 1);
            this.remove(popUpWindows, PopUpEnum.HOME_SIGN_GUIDE);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u65b0\u4eba\u5f15\u5bfc\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

