/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.lottery.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.LotteryFacadeService;
import com.bxm.fossicker.activity.facade.model.LotteryDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.LOTTERY_HOME, order=PopUpProcessOrderEn.CUSTOM)
public class LotteryHomepageWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private LotteryFacadeService lotteryFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            LotteryDTO topLottery = this.lotteryFacadeService.getTopLottery();
            commonPopUpWindowsEntryList.forEach(p -> {
                if (null != topLottery) {
                    p.setExt(JSON.toJSONString((Object)topLottery));
                }
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55 \u5168\u540d\u5927\u62bd\u5956\u9996\u9875 \u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }

    public class LotteryHomepageExt {
        private Long lotteryId;

        public Long getLotteryId() {
            return this.lotteryId;
        }

        public void setLotteryId(Long lotteryId) {
            this.lotteryId = lotteryId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LotteryHomepageExt)) {
                return false;
            }
            LotteryHomepageExt other = (LotteryHomepageExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$lotteryId = this.getLotteryId();
            Long other$lotteryId = other.getLotteryId();
            return !(this$lotteryId == null ? other$lotteryId != null : !((Object)this$lotteryId).equals(other$lotteryId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LotteryHomepageExt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $lotteryId = this.getLotteryId();
            result = result * 59 + ($lotteryId == null ? 43 : ((Object)$lotteryId).hashCode());
            return result;
        }

        public String toString() {
            return "LotteryHomepageWindowsProcess.LotteryHomepageExt(lotteryId=" + this.getLotteryId() + ")";
        }
    }
}

