/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.vipPage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@PopUpProcess(special=PopUpEnum.TOBE_FOREVER_VIP_NOTICE, order=PopUpProcessOrderEn.CUSTOM)
public class TobeForeverVipPopWindowsProcess
extends AbstractPopUpWindowsProcess {
    private static final Logger log = LoggerFactory.getLogger(TobeForeverVipPopWindowsProcess.class);
    @Autowired
    private VipFacadeService vipFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {
        if (!Objects.equals(popUpWindows.getParam().getPosition().intValue(), 5)) {
            return false;
        }
        if (StringUtils.compareVersion((String)popUpWindows.getParam().getCurVer(), (String)"1.6.0") < 0) {
            this.remove(popUpWindows, PopUpEnum.TOBE_FOREVER_VIP_NOTICE);
            return false;
        }
        return true;
    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();
        Integer num = this.vipFacadeService.pushTobeForeverVipContent(userId);
        if (Objects.isNull(num) || num == 0) {
            this.remove(popUpWindows, PopUpEnum.TOBE_FOREVER_VIP_NOTICE);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        this.vipFacadeService.removeTobeForeverVipPush(popUpWindows.getParam().getUserId());
    }
}

