package com.bxm.fossicker.enums;

/**
 * 短信类型枚举
 * @author liujia
 */
public enum SmsTempEnum {
    /**
     * 登录短信
     */
    LOGIN("【趣淘金】您的验证码为 {}，请勿向他人泄露。", SmsTypeEnum.SMS_CODE),
    /**
     * 重置密码短信
     */
    RESET("【趣淘金】您的验证码为 {}，请勿向他人泄露。", SmsTypeEnum.SMS_CODE),
    /**
     * 绑定手机号码短信
     */
    BIND("【趣淘金】您的验证码为 {}，请勿向他人泄露。", SmsTypeEnum.SMS_CODE),


    // -----------------------以上是验证码模板------------------------------------

    /**
     * 邀请亲友短信
     * 写在配置文件中
     * 模板：【趣淘金】有人@你，你有一份新人专享礼品即将到期，戳 https://webtest.91huola.com/h5/fossicker/download_gold.html?shareUserId={$var} 速速领取！退订回T
     */
    RELATIVE_INVITE("relativeInviteSms", SmsTypeEnum.ARGUMENT_FROM_CONFIG),

    /**
     * 提醒好友
     * 写在配置文件中
     * 模板：【【趣淘金】今日还可领取12000金币，今天24:00不领作废！金币余额可提走，速来戳 https://webtest.91huola.com/h5/fossicker/download_gold.html?shareUserId={$var} 退订回T
     */
    REIMNDER_SMS("【趣淘金】Hi，好友提醒你今日还可领取12000金币，今天24:00不领作废！金币余额可提走，速来领噢～ 退订回T", SmsTypeEnum.ARGUMENT),

    ;

    /**
     * 短信模板 or 从配置文件中获取短信模板的key
     */
    private String template;

    /**
     * 1: 验证码
     * 2: 根据 template 的值查找配置文件对应的短信模板
     */
    private SmsTypeEnum smsType;

    SmsTempEnum(String template, SmsTypeEnum smsType) {
        this.template = template;
        this.smsType = smsType;
    }

    public String getTemplate() {
        return template;
    }

    public SmsTypeEnum getSmsType() {
        return smsType;
    }
}
