package com.bxm.fossicker.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * 用户模块的redis缓存键值定义
 * @author liujia
 */
public class UserRedisKeyConstant {
    private static KeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("user");

    /**
     * 用户详情缓存，hash结构存储，subkey为用户ID
     */
    public static KeyGenerator HASH_USER_DETAIL = BASE_KEY.copy().setGroup("cache").setKey("info");

    /**
     * 用户token缓存，用户每次登陆时重新创建
     */
    public static KeyGenerator HASH_USER_TOKEN = BASE_KEY.copy().setGroup("cache").setKey("token");

    /**
     * 静默用户缓存，记录处于静默状态的用户ID
     */
    public static KeyGenerator SET_MUTED_USER = BASE_KEY.copy().setGroup("cache").setKey("muted");

    /**
     * 用户ID自增长值，用于给新用户赋予ID值
     */
    public static KeyGenerator STR_USER_ID = BASE_KEY.copy().setGroup("increment").setKey("uid");

    /**
     * 用户账户缓存
     */
    public static KeyGenerator HASH_USER_ACCOUNT = BASE_KEY.copy().setGroup("cache").setKey("account");

    /**
     * 用户今日金币数缓存
     */
    public static KeyGenerator USER_TODAY_GOLD = BASE_KEY.copy().setGroup("cache").setKey("todayGold");

    /**
     * 用户今日停留时间缓存
     */
    public static KeyGenerator USER_TODAY_LIVING_TIME = BASE_KEY.copy().setGroup("cache").setKey("todayLivingTime");


    private static KeyGenerator USER_DISTRIBUTE_KEY = BASE_KEY.copy().setGroup("distributeKey");

    /**
     * 添加现金账户处理的分布式锁
     */
    public static KeyGenerator CASH_ACCOUNT_KEY = USER_DISTRIBUTE_KEY.copy().setKey("cashAccountKey");

    /**
     * 添加金币账户处理的分布式锁
     */
    public static KeyGenerator GOLD_ACCOUNT_KEY = USER_DISTRIBUTE_KEY.copy().setKey("goldAccountKey");

    private UserRedisKeyConstant() {
    }
}
