package com.bxm.fossicker.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * 商品模块 redis键值定义
 */
public class CommonCommodityRedisKey {

    private static KeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("order");

    private static final KeyGenerator COMMODITY_INFO_BASE_KEY = DefaultKeyGenerator.build("commodity", "cache");

    /**
     * 定时同步订单数据 缓存状态值
     */
    public static KeyGenerator COMMODITY_NEWBIE_USER_SET = BASE_KEY.copy().setGroup("newbie").setKey("user");


    /**
     * 本地商品缓存key
     * 需要加一级key 避免单个key数据过多
     * CommodityInfoRedisKeyConstant.LOCAL_COMMODITY_INFO.copy(Math.abs(commodityId.hashCode()) % 10)
     */
    public static final KeyGenerator LOCAL_COMMODITY_INFO = COMMODITY_INFO_BASE_KEY.copy().setKey("localCommodityInfo");


}
