package com.bxm.fossicker.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by Gonzo on 2019-07-09.
 * @deprecated 与component中的工具定义重复，直接使用SimpleDateFormat有并发出错的风险
 */
@Slf4j
@Deprecated
public class DateUtils {

    public static final String FORMAT_DATETIME_LONG = "yyyyMMddHHmmss";

    public static final String FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";

    public static final String FORMAT_DATEMONTH = "yyyy-MM";

    public static final String FORMAT_DATE = "yyyy-MM-dd";

    public static final String FORMAT_TIME = "HH:mm:ss";

    public static final String FORMAT_TIME_HOUR_MIN = "HH:mm";

    public static final String FORMAT_TIME_HHMMSS = "HHmmss";

    public static final String FORMAT_DATETIME_YYYYMMDD = "yyyyMMdd";

    public static final String FORMAT_DATETIME_4MIN = "yyyyMMddHHmm";

    public static final String FORMAT_DATETIME_YYMMDD = "yyMMdd";

    public static final String FORMAT_DATETIME_YYYYMMDD1 = "yyyy/MM/dd";


    /**
     * 将日期字符串转换为date
     * @param dateStr
     * @param strFormat
     * @return
     */
    public final static Date parse(String dateStr, String strFormat) {
        try {
            if (StringUtils.isNotBlank(dateStr) && StringUtils.isNotBlank(strFormat)) {
                return new SimpleDateFormat(strFormat).parse(dateStr);
            }
        } catch (Exception e) {
            log.error("", e);
        }

        return null;
    }

    /**
     * 将日期转换为指定格式字符串
     * @param date
     * @param strFormat
     * @return
     */
    public final static String format(Date date, String strFormat) {
        return new SimpleDateFormat(strFormat).format(date == null ? new Date() : date);
    }

    /**
     * 获取昨天这个时候
     * @return
     */
    public static Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, -1);

        return cal.getTime();
    }

    /**
     * 获取明天这个时候
     * @return
     */
    public static Date getTomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DAY_OF_MONTH, 1);

        return cal.getTime();
    }

    /**
     * 获取给定时间的后一天
     * @param dayTime
     * @return
     */
    public static Date getNextDayTime(Date dayTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dayTime);
        cal.add(Calendar.DAY_OF_MONTH, 1);

        return cal.getTime();
    }

    /**
     * 获取某一天的 0:00:00 如果day为空则获取今天
     * @Author: Gonzo
     */
    public static Date getDayStartTime(Date day) {
        return com.bxm.newidea.component.tools.DateUtils.clearTimePart(day);
    }

    /**
     * 获取某一天的 23:59:59 如果day为空则获取今天
     * @Author: Gonzo
     */
    public static Date getDayEndTime(Date day) {
        Calendar cal = Calendar.getInstance();
        if (day != null) {
            cal.setTime(day);
        }

        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        return cal.getTime();
    }

    /**
     * 获取某个时间后延day天的最大时间
     * @param sourceTime
     * @param day 顺延天数
     * @return
     */
    public static Date extendEndTime(Date sourceTime,int day){
        Calendar c = Calendar.getInstance();
        c.setTime(sourceTime);   //设置时间
        c.add(Calendar.DATE, day);
        c.set(Calendar.HOUR_OF_DAY, 23);
        c.set(Calendar.MINUTE, 59);
        c.set(Calendar.SECOND, 59);
        Date date = c.getTime();
        return date;
    }


    public static long getBetweenSecond(Date d1, Date d2) {
        long between = d1.getTime() - d2.getTime();

        return between > 0 ? between : between * -1;
    }

}
