//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.bxm.fossicker.util;

import com.bxm.newidea.component.tools.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.Map.Entry;

/**
 * md5工具类
 */
public class MD5Sign {
    private static final String SIGN_KEY = "sign";

    private MD5Sign() {
    }

    public static String md5(String inStr) {
        try {
            return DigestUtils.md5Hex(inStr.getBytes(StandardCharsets.UTF_8.name()));
        } catch (UnsupportedEncodingException var2) {
            throw new RuntimeException("MD5签名过程中出现错误");
        }
    }

    public static String sign(HashMap<String, String> params, String appSecret) {
        StringBuilder valueSb = new StringBuilder();
        params.put("appSecret", appSecret);
        Map<String, String> sortParams = new TreeMap<>(params);
        Set<Entry<String, String>> entries = sortParams.entrySet();

        for (Object entry1 : entries) {
            Entry entry = (Entry) entry1;
            valueSb.append((String) entry.getValue());
        }

        params.remove("appSecret");
        return md5(valueSb.toString());
    }

    public static boolean verify(String appSecret, HttpServletRequest request) throws Exception {
        String sign = request.getParameter(SIGN_KEY);
        if (sign == null) {
            throw new Exception(URLEncoder.encode("请求中没有带签名", "UTF-8"));
        } else if (request.getParameter("timestamp") == null) {
            throw new Exception(URLEncoder.encode("请求中没有带时间戳", "UTF-8"));
        } else {
            HashMap<String, String> params = new HashMap<>();
            Enumeration enu = request.getParameterNames();

            while (enu.hasMoreElements()) {
                String paramName = ((String) enu.nextElement()).trim();
                if (!SIGN_KEY.equals(paramName)) {
                    params.put(paramName, URLDecoder.decode(request.getParameter(paramName), "UTF-8"));
                }
            }

            params.put("appSecret", appSecret);
            Map<String, String> sortParams = new TreeMap<>(params);
            Set<Entry<String, String>> entries = sortParams.entrySet();
            StringBuilder valueSb = new StringBuilder();

            for (Object entry1 : entries) {
                Entry entry = (Entry) entry1;
                valueSb.append(entry.getValue());
            }

            return StringUtils.equals(md5(valueSb.toString()), sign);
        }
    }
}
