package com.bxm.fossicker.util;

import com.bxm.newidea.component.tools.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

/**
 * 编号生成器
 * @author RDuser
 */
public class NidGeneratorUtil {

    private final static Logger log = LoggerFactory.getLogger(NidGeneratorUtil.class);

    private static final SimpleDateFormat SDF_TIME = new SimpleDateFormat("yyMMddHHmmss");

    private static int getHashCode() {
        int hashCode = UUID.randomUUID().toString().hashCode();
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        return hashCode;
    }

    private static String getRandomStr(int size) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < size; i++) {
            result.append(RandomUtils.nextInt(1, 10));
        }
        return result.toString();
    }

    /**
     * 订单号生成
     * @param idType 订单前缀
     * @return
     */
    public static String getOrderNo(String idType) {
        return idType + SDF_TIME.format(new Date()) + getRandomStr(8);
    }

    public static String getCodeNo(String idType) {
        return idType + getRandomStr(6);
    }

}
