package com.bxm.fossicker.util;

import com.bxm.fossicker.util.animate.AnimatedGifEncoder;
import com.bxm.fossicker.util.animate.GifDecoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import sun.awt.SunHints;

import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URL;

/**
 * @Author: pf.w
 * @Date: 2019/10/24 16:17
 */

public class PictureMerge {

    public static void drawTextInImg(String filePath, String outPath, FontText text) throws Exception {
        ImageIcon imgIcon = new ImageIcon(filePath);
        Image img = imgIcon.getImage();
        File file = new File(filePath);
        BufferedImage bimage = ImageIO.read(file);
        Graphics g = bimage.createGraphics();
        g.setColor(getColor(text.getWm_text_color()));
        g.drawImage(img, 0, 0, null);
        Font font = null;
        if (StringUtils.isEmpty(text.getWm_text_font())
                && text.getWm_text_size() != null) {
            font = new Font(text.getWm_text_font(), Font.BOLD,
                    text.getWm_text_size());
        } else {
            font = new Font(null, Font.BOLD, 50);
        }

        g.setFont(font);
        g.drawString(text.getText(), 180, 200);
        g.dispose();
        FileOutputStream out = new FileOutputStream(outPath);
        ImageIO.write(bimage, "gif", out);
        out.close();

    }

    // color #2395439
    public static Color getColor(String color) {
        if (color.charAt(0) == '#') {
            color = color.substring(1);
        }
        if (color.length() != 6) {
            return null;
        }
        try {
            int r = Integer.parseInt(color.substring(0, 2), 16);
            int g = Integer.parseInt(color.substring(2, 4), 16);
            int b = Integer.parseInt(color.substring(4), 16);
            return new Color(r, g, b);
        } catch (NumberFormatException nfe) {
            return null;
        }
    }

    /**
     *
     * @param markContent
     * @param imgUrl
     * @param size
     * @param x
     * @param y
     * @return
     * @throws Exception
     */
    public static byte[] getGifSticker(String markContent, String imgUrl,int size,int x,int y) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            InputStream inputStream1 =  new ByteArrayInputStream(IOUtils.toByteArray(new URL(imgUrl)));
            GifDecoder decoder = new GifDecoder();
            //读入gif数据流
            decoder.read(inputStream1);
            Font font = new Font(null, Font.BOLD, size);
            //读取帧数
            int frameCount = decoder.getFrameCount();
            AnimatedGifEncoder encoder = new AnimatedGifEncoder();
            String url = "D:\\" + System.currentTimeMillis() + ".gif";
            encoder.start(outputStream);
            encoder.setRepeat(0);
            Graphics2D g = null;
            /**
             * 对GIF进行拆分
             * 每一帧进行文字处理
             * 组装
             */
            for (int i = 0; i < frameCount; i++) {
                //初始化图像
                g = (Graphics2D) decoder.getFrame(i).getGraphics();
                /**
                 * RenderingHint是对图片像素，锯齿等等做的优化，可保证生成的图片放大锯齿点阵也不会很明显
                 */
                g.setRenderingHint(SunHints.KEY_ANTIALIASING, SunHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(SunHints.KEY_TEXT_ANTIALIASING, SunHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
                g.setColor(Color.red);
                g.setFont(font);
                g.setFont(font);
                //设置打印文字和坐标
                g.drawString(markContent, x, y);
                g.dispose();
                //组装每一帧
                encoder.addFrame(decoder.getFrame(i));
                //设置每帧的切换时间
                if (i != frameCount - 1) {
                    encoder.setDelay(decoder.getDelay(i));
                }
            }
            encoder.finish();
            byte b[] = outputStream.toByteArray();
            return b;
        } finally {
            try {
                if (null != outputStream)
                    outputStream.close();
            } catch (IOException e) {

            }
        }
    }

}
