package com.bxm.fossicker.vo;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.math.NumberUtils;

@ApiModel(description = "api传递的通用基础参数")
@EqualsAndHashCode(callSuper = true)
@Data
public class BasicParam extends BaseBean {

    @ApiModelProperty(value = "通用参数：平台类型,1:ANDROID,2:IOS,3:WEB", required = true)
    private int platform;

    @ApiModelProperty(value = "通用参数：当前APP的发布版本", required = true)
    private String curVer;

    @ApiModelProperty(value = "通用参数：用户安装包渠道来源")
    private String chnl;

    @ApiModelProperty(value = "通用参数：设备ID，上报设备信息后获取")
    private String devcId;

    @ApiModelProperty(value = "通用参数：客户端时间，用于判断是否超时请求，如请求时间与服务端时间存在一定的差异，将会拒绝请求")
    private Long cliTime;

    /**
     * 兼容历史版本的设备ID，转换为长整型
     * @return 设备ID整形数值
     */
    @ApiModelProperty(hidden = true)
    public Long getDevcIdNum() {
        if (NumberUtils.isDigits(devcId)) {
            return Long.valueOf(devcId);
        }
        return 0L;
    }
}
