package com.bxm.fossicker.order.common.utils;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.redis.utils.RateLimiter;
import com.bxm.newidea.component.redis.utils.RateLimiterFactory;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


/**
 * @Author: pf.w
 * @Date: 2019/9/17 10:03
 */

@Component
@Log4j2
public class ApiLimiterFactory {

    @Autowired
    private RateLimiterFactory rateLimiterFactory;

    //限流 base key
    KeyGenerator LIMIT_BASE_KEY = DefaultKeyGenerator.build("limit", "api");

    /**
     * 订单表限流器
     * @param apiId  接口ID
     * @return
     */
    public Long  getPermitForOrder(String apiId) throws InterruptedException {
        KeyGenerator LIMIT_ORDER_KEY = LIMIT_BASE_KEY.copy().appendKey(apiId);
        RateLimiter rateLimiterOrder = rateLimiterFactory.build(LIMIT_ORDER_KEY, 10D, 3);
        return rateLimiterOrder.acquire(1L);
    }

}
