/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.external.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.order.common.utils.ApiLimiterFactory;
import com.bxm.fossicker.order.config.OrderInfoProperties;
import com.bxm.fossicker.order.model.dto.TbOrderPageInfo;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.enums.OrderTypeEnum;
import com.bxm.fossicker.order.service.external.TbOrderService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.TbkOrderDetailsGetRequest;
import com.taobao.api.response.TbkOrderDetailsGetResponse;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TbOrderServiceImpl
implements TbOrderService {
    private static final Logger log = LoggerFactory.getLogger(TbOrderServiceImpl.class);
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private OrderInfoProperties orderInfoProperties;
    @Autowired
    private ApiLimiterFactory reteLlimiterFactory;

    @Override
    public TbOrderPageInfo<OrderInfoBean> pullOrderNew(Long pageNo, Long pageSize, String positionIndex, Date orderStartTime, Date orderEndTime, int type) {
        return this.pullOrderNew(pageNo, pageSize, positionIndex, DateUtils.formatDateTime((Date)orderStartTime), DateUtils.formatDateTime((Date)orderEndTime), type);
    }

    @Override
    public TbOrderPageInfo<OrderInfoBean> pullOrderNew(Long pageNo, Long pageSize, String positionIndex, LocalDateTime orderStartTime, LocalDateTime orderEndTime, int type) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return this.pullOrderNew(pageNo, pageSize, positionIndex, formatter.format(orderStartTime), formatter.format(orderEndTime), type);
    }

    @Override
    public TbOrderPageInfo<OrderInfoBean> pullOrderNew(Long pageNo, Long pageSize, String positionIndex, String orderStartTime, String orderEndTime, int type) {
        TbkOrderDetailsGetResponse rsp;
        TbOrderPageInfo tbOrderPageInfo = new TbOrderPageInfo();
        try {
            this.reteLlimiterFactory.getPermitForOrder(this.orderInfoProperties.getTbCommodityUrl());
        }
        catch (InterruptedException e) {
            log.error("\u8ba2\u5355\u4ee4\u724c\u83b7\u53d6\u5f02\u5e38\uff1a", (Throwable)e);
        }
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.orderInfoProperties.getTbCommodityUrl(), this.orderInfoProperties.getTbCommodityAppKey(), this.orderInfoProperties.getTbCommodityAppSecret());
        TbkOrderDetailsGetRequest req = new TbkOrderDetailsGetRequest();
        req.setQueryType(Long.valueOf(1L));
        req.setPositionIndex(positionIndex);
        req.setPageSize(pageSize);
        req.setPageNo(pageNo);
        req.setStartTime(orderStartTime);
        req.setEndTime(orderEndTime);
        req.setMemberType(Long.valueOf(2L));
        this.convertSceneType(req, type);
        try {
            rsp = (TbkOrderDetailsGetResponse)client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u62c9\u53d6\u8ba2\u5355\u5f02\u5e38, \u62c9\u53d6\u65f6\u95f4:{}", (Object)orderStartTime, (Object)e);
            return null;
        }
        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty((Collection)rsp.getData().getResults())) {
            log.info("\u4ece\u6dd8\u5b9d\u83b7\u53d6\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a\u6216\u8005\u5931\u8d25,\u67e5\u8be2\u65f6\u95f4\u4e3a:{},\u9519\u8bef\u4fe1\u606f:{}", (Object)orderStartTime, JSON.toJSON((Object)rsp));
            return null;
        }
        List resultRsp = rsp.getData().getResults();
        ArrayList<OrderInfoBean> orderInfoList = new ArrayList<OrderInfoBean>();
        for (TbkOrderDetailsGetResponse.PublisherOrderDto publisherOrderDto : resultRsp) {
            orderInfoList.add(this.convertOrderInfoNew(publisherOrderDto, type));
        }
        TbkOrderDetailsGetResponse.OrderPage tbOrderPage = rsp.getData();
        tbOrderPageInfo.setHasNext(tbOrderPage.getHasNext());
        tbOrderPageInfo.setHasPre(tbOrderPage.getHasPre());
        tbOrderPageInfo.setPageNo(tbOrderPage.getPageNo());
        tbOrderPageInfo.setPageSize(tbOrderPage.getPageSize());
        tbOrderPageInfo.setPositionIndex(tbOrderPage.getPositionIndex());
        tbOrderPageInfo.setList(orderInfoList);
        return tbOrderPageInfo;
    }

    private OrderInfoBean convertOrderInfoNew(TbkOrderDetailsGetResponse.PublisherOrderDto tbOrderInfo, int type) {
        StringBuilder httpsPre = new StringBuilder("https:");
        OrderInfoBean orderInfo = OrderInfoBean.builder().id(this.sequenceCreater.nextLongId()).goodsId(Objects.toString(tbOrderInfo.getItemId(), null)).goodsName(tbOrderInfo.getItemTitle()).relationId(Objects.toString(tbOrderInfo.getRelationId(), null)).specialId(Objects.toString(tbOrderInfo.getSpecialId(), null)).orderSn(Objects.toString(tbOrderInfo.getTradeId(), null)).orderParentSn(Objects.toString(tbOrderInfo.getTradeParentId(), null)).goodsPrice(StringUtils.isBlank((CharSequence)tbOrderInfo.getItemPrice()) ? null : new BigDecimal(tbOrderInfo.getItemPrice())).goodsNum(tbOrderInfo.getItemNum()).payPrice(StringUtils.isBlank((CharSequence)tbOrderInfo.getAlipayTotalPrice()) ? new BigDecimal("0.00") : new BigDecimal(tbOrderInfo.getAlipayTotalPrice())).sourceOrderCreateTime(DateUtils.parseDateTime((String)tbOrderInfo.getTkCreateTime())).sourceOrderEarningTime(DateUtils.parseDateTime((String)tbOrderInfo.getTkEarningTime())).commission(StringUtils.isBlank((CharSequence)tbOrderInfo.getPubSharePreFee()) ? null : new BigDecimal(tbOrderInfo.getPubSharePreFee())).sourceOwnerOrderStatus((null == tbOrderInfo.getTkStatus() ? null : Integer.valueOf(tbOrderInfo.getTkStatus().intValue())).intValue()).source("TB").imgUrl(httpsPre.append(tbOrderInfo.getItemImg()).toString()).pid(this.parsePid(tbOrderInfo)).type(type).tbOrderType(tbOrderInfo.getOrderType()).createTime(new Date()).build();
        return orderInfo;
    }

    private String parsePid(TbkOrderDetailsGetResponse.PublisherOrderDto tbOrderInfo) {
        StringBuilder pid = new StringBuilder("mm_456760114_").append(tbOrderInfo.getSiteId()).append("_").append(tbOrderInfo.getAdzoneId());
        return pid.toString();
    }

    private void convertSceneType(TbkOrderDetailsGetRequest req, int orderType) {
        if (OrderTypeEnum.CHANNEL_ORDER.getCode() == orderType) {
            req.setOrderScene(Long.valueOf(2L));
            return;
        }
        if (OrderTypeEnum.GENERAL_ORDER.getCode() == orderType) {
            req.setOrderScene(Long.valueOf(1L));
            return;
        }
        req.setOrderScene(Long.valueOf(2L));
    }
}

