/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.constant.CommonCommodityRedisKey;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.order.common.enums.OrderStatusEnum;
import com.bxm.fossicker.order.common.enums.TbOrderStatusEnum;
import com.bxm.fossicker.order.domain.OrderExtendInfoExtendMapper;
import com.bxm.fossicker.order.domain.OrderInfoMapper;
import com.bxm.fossicker.order.domain.OrderProfitMapper;
import com.bxm.fossicker.order.integration.PushMessageIntegrationService;
import com.bxm.fossicker.order.model.dto.VipZeroOrderExtendJson;
import com.bxm.fossicker.order.model.entity.OrderExtendInfoBean;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.entity.OrderProfitBean;
import com.bxm.fossicker.order.model.enums.ProfitTypeEnum;
import com.bxm.fossicker.order.service.OrderCommissionService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.SuperiorDto;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.CommissionDraftParam;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderCommissionServiceImpl
implements OrderCommissionService {
    private static final Logger log = LoggerFactory.getLogger(OrderCommissionServiceImpl.class);
    @Resource
    private OrderInfoMapper orderInfoMapper;
    @Resource
    private OrderProfitMapper orderProfitMapper;
    @Resource
    private UserInfoFacadeService userInfoFacadeService;
    @Resource
    private AccountFacadeService accountFacadeService;
    @Resource
    private TaskFacadeService taskFacadeService;
    @Resource
    private PushMessageIntegrationService pushMessageIntegrationService;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private RedisListAdapter redisListAdapter;
    @Resource
    private VipFacadeService vipFacadeService;
    @Autowired
    private OrderExtendInfoExtendMapper orderExtendInfoExtendMapper;

    @Deprecated
    public Boolean addCommissionV0(String orderId) {
        SuperiorDto superiorDto;
        OrderInfoBean orderInfo = this.orderInfoMapper.getOrderInfoByOrderId(orderId);
        if (null == orderInfo) {
            log.error("\u65e0\u6b64\u8ba2\u5355\u4fe1\u606f, \u67e5\u8be2\u7684\u8ba2\u5355id\u4e3a:{}", (Object)orderId);
            return false;
        }
        String specialId = orderInfo.getSpecialId();
        String relationId = orderInfo.getRelationId();
        SuperiorDto superiorDtoBySpecialId = this.userInfoFacadeService.getSuperiorBySpecialId(orderInfo.getSpecialId());
        SuperiorDto superiorDtoByRelationId = this.userInfoFacadeService.getSuperiorByRelationId(relationId);
        boolean isInvalidOrder = OrderStatusEnum.isInvalidOrder((Integer)orderInfo.getOrderStatus());
        boolean isShare = false;
        if (this.isPurchaseBySelf(superiorDtoBySpecialId, superiorDtoByRelationId)) {
            Long taskCompleteUserId;
            superiorDto = superiorDtoBySpecialId;
            if (null == superiorDto.getUserId()) {
                log.info("\u4f1a\u5458id({})\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5e73\u53f0\u7684id", (Object)specialId);
                return false;
            }
            BigDecimal purchaseCommission = orderInfo.getPurchaseCommission();
            boolean isVip = this.vipFacadeService.isVip(superiorDto.getUserId());
            if (isVip && Objects.nonNull(orderInfo.getVipPurchaseCommission())) {
                purchaseCommission = orderInfo.getVipPurchaseCommission();
            }
            this.addUserAccountByDraftCommission(superiorDto.getUserId(), purchaseCommission, orderId, UserCashFlowTypeEnum.PURCHASED_COMMISSION_REBATE, isInvalidOrder);
            this.recordOrderProfit(orderInfo, superiorDto.getUserId(), superiorDto.getUserId(), ProfitTypeEnum.PURCHASE, purchaseCommission);
            if (!isInvalidOrder) {
                this.pushMessageIntegrationService.pushPurchase(superiorDto.getUserId(), purchaseCommission, orderInfo.getOrderSn());
            }
            if (isVip && !isInvalidOrder && Objects.nonNull(orderInfo.getVipPurchaseCommission())) {
                this.vipFacadeService.addVipCommission(superiorDto.getUserId(), orderInfo.getVipPurchaseCommission().subtract(orderInfo.getPurchaseCommission()), 1);
            }
            if (null != (taskCompleteUserId = superiorDto.getUserId())) {
                KeyGenerator redisKey = CommonCommodityRedisKey.COMMODITY_NEWBIE_USER_SET;
                this.redisSetAdapter.add(redisKey, new Object[]{taskCompleteUserId});
                if (!TbOrderStatusEnum.INVALID.getStatus().equals(orderInfo.getSourceOwnerOrderStatus())) {
                    this.taskFacadeService.complete(taskCompleteUserId, ActivityFacadeEnum.FIRST_SHOP);
                }
            }
        } else {
            isShare = true;
            superiorDto = superiorDtoByRelationId;
            if (null == superiorDto || null == superiorDto.getUserId()) {
                log.info("\u7528\u6237relationId({})\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5e73\u53f0\u7684id", (Object)relationId);
                return false;
            }
            BigDecimal purchaseCommission = orderInfo.getPurchaseCommission();
            boolean isVip = this.vipFacadeService.isVip(superiorDto.getUserId());
            if (isVip && Objects.nonNull(orderInfo.getVipPurchaseCommission())) {
                purchaseCommission = orderInfo.getVipPurchaseCommission();
            }
            this.addUserAccountByDraftCommission(superiorDto.getUserId(), purchaseCommission, orderId, UserCashFlowTypeEnum.SHARED_COMMISSION_REBATE, isInvalidOrder);
            this.recordOrderProfit(orderInfo, superiorDto.getUserId(), superiorDto.getUserId(), ProfitTypeEnum.SHARE, purchaseCommission);
            if (!isInvalidOrder) {
                this.pushMessageIntegrationService.pushShare(superiorDto.getUserId(), purchaseCommission, orderInfo.getOrderSn());
            }
            if (isVip && !isInvalidOrder && Objects.nonNull(orderInfo.getVipPurchaseCommission())) {
                this.vipFacadeService.addVipCommission(superiorDto.getUserId(), orderInfo.getVipPurchaseCommission().subtract(orderInfo.getPurchaseCommission()), 1);
            }
        }
        this.addOrderToPopwindows(superiorDto.getUserId(), orderInfo.getId().toString());
        if (null != superiorDto.getSuperiorUserId()) {
            this.addUserAccountByDraftCommission(superiorDto.getSuperiorUserId(), orderInfo.getParentCommission(), orderId, UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);
            this.recordOrderProfit(orderInfo, superiorDto.getSuperiorUserId(), superiorDto.getUserId(), ProfitTypeEnum.PARENT, orderInfo.getParentCommission());
            if (!isInvalidOrder) {
                if (isShare) {
                    this.pushMessageIntegrationService.pushShareContribute(superiorDto.getSuperiorUserId(), orderInfo.getParentCommission(), orderInfo.getOrderSn());
                } else {
                    this.pushMessageIntegrationService.pushPurchaseContribute(superiorDto.getSuperiorUserId(), orderInfo.getParentCommission(), orderInfo.getOrderSn());
                }
            }
            if (null != superiorDto.getTopUserId()) {
                this.addUserAccountByDraftCommission(superiorDto.getTopUserId(), orderInfo.getGrandparentCommission(), orderId, UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);
                this.recordOrderProfit(orderInfo, superiorDto.getTopUserId(), superiorDto.getUserId(), ProfitTypeEnum.GRANDPARENT, orderInfo.getGrandparentCommission());
                if (!isInvalidOrder) {
                    if (isShare) {
                        this.pushMessageIntegrationService.pushShareContribute(superiorDto.getTopUserId(), orderInfo.getGrandparentCommission(), orderInfo.getOrderSn());
                    } else {
                        this.pushMessageIntegrationService.pushPurchaseContribute(superiorDto.getTopUserId(), orderInfo.getGrandparentCommission(), orderInfo.getOrderSn());
                    }
                }
                this.addOrderToPopwindows(superiorDto.getTopUserId(), orderInfo.getId().toString());
            }
            this.addOrderToPopwindows(superiorDto.getSuperiorUserId(), orderInfo.getId().toString());
        }
        return true;
    }

    @Override
    public boolean addCommission(String orderSn) {
        OrderInfoBean orderInfo = this.orderInfoMapper.getOrderInfoByOrderId(orderSn);
        if (Objects.isNull(orderInfo)) {
            log.warn("\u6dfb\u52a0\u8fd4\u4f63\u4fe1\u606f\u5931\u8d25\uff0c\u65e0\u6b64\u8ba2\u5355\u4fe1\u606f, \u67e5\u8be2\u7684\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderSn);
            return false;
        }
        SuperiorDto superiorDtoByRelationId = this.userInfoFacadeService.getSuperiorByRelationId(orderInfo.getRelationId());
        if (log.isDebugEnabled()) {
            log.debug("\u8ba2\u5355: {} \u83b7\u53d6\u5230\u7684\u53d7\u76ca\u4ebaid: {}", (Object)orderInfo.getOrderSn(), (Object)superiorDtoByRelationId.getUserId());
        }
        if (Objects.isNull(superiorDtoByRelationId) || Objects.isNull(superiorDtoByRelationId.getUserId())) {
            log.info("\u7528\u6237relationId({}) \u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u5e73\u53f0\u7684id", (Object)orderInfo.getRelationId());
            return false;
        }
        SuperiorDto superiorDtoBySpecialId = this.userInfoFacadeService.getSuperiorBySpecialId(orderInfo.getSpecialId());
        boolean isPurchaseBySelf = this.isPurchaseBySelf(superiorDtoBySpecialId, superiorDtoByRelationId);
        boolean isInvalidOrder = OrderStatusEnum.isInvalidOrder((Integer)orderInfo.getOrderStatus());
        Long userId = superiorDtoByRelationId.getUserId();
        boolean isVip = this.vipFacadeService.isVip(userId);
        log.info("\u6dfb\u52a0\u8fd4\u4f63\u4fe1\u606f userId; {} superiorUserId: {} topUserId: {} isPurchaseBySelf: {} isInvalidOrder: {} isVip: {}", new Object[]{userId, superiorDtoByRelationId.getSuperiorUserId(), superiorDtoByRelationId.getTopUserId(), isPurchaseBySelf, isInvalidOrder, isVip});
        BigDecimal commission = isVip ? orderInfo.getVipPurchaseCommission() : orderInfo.getPurchaseCommission();
        this.recordOrderProfit(orderInfo, userId, userId, isPurchaseBySelf ? ProfitTypeEnum.PURCHASE : ProfitTypeEnum.SHARE, commission);
        this.purchaseInfoRecode(superiorDtoBySpecialId.getUserId(), isInvalidOrder, orderInfo, commission, isVip, isPurchaseBySelf);
        this.recordOrderProfit(orderInfo, superiorDtoByRelationId.getSuperiorUserId(), superiorDtoByRelationId.getUserId(), ProfitTypeEnum.PARENT, orderInfo.getParentCommission());
        this.superiorInfoRecode(superiorDtoByRelationId.getSuperiorUserId(), orderInfo, isInvalidOrder);
        this.recordOrderProfit(orderInfo, superiorDtoByRelationId.getTopUserId(), superiorDtoByRelationId.getUserId(), ProfitTypeEnum.GRANDPARENT, orderInfo.getGrandparentCommission());
        this.topInfoRecode(superiorDtoByRelationId.getTopUserId(), orderInfo, isInvalidOrder);
        return true;
    }

    @Override
    public boolean updateVipZeroOrderProfitToSuccess(Long orderId) {
        VipZeroOrderExtendJson json;
        OrderInfoBean orderInfoBean = this.orderInfoMapper.getOrderInfoByPrimaryKey(orderId);
        if (Objects.isNull(orderInfoBean)) {
            log.warn("\u6839\u636e\u8ba2\u5355id: {} \u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u4fe1\u606f", (Object)orderId);
            return false;
        }
        boolean isInvalidOrder = OrderStatusEnum.isInvalidOrder((Integer)orderInfoBean.getOrderStatus());
        if (isInvalidOrder) {
            log.warn("\u8ba2\u5355\u53f7: {} \u7684\u8ba2\u5355\u5df2\u5931\u6548", (Object)orderInfoBean.getOrderSn());
            return false;
        }
        OrderExtendInfoBean extendInfoBean = this.orderExtendInfoExtendMapper.getByOrderId(orderId);
        if (Objects.isNull(extendInfoBean)) {
            log.warn("\u6839\u636e\u8ba2\u5355id: {} \u67e5\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355\u62d3\u5c55\u4fe1\u606f", (Object)orderId);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)extendInfoBean.getExtendJson()) || Objects.isNull(json = (VipZeroOrderExtendJson)JSON.parseObject((String)extendInfoBean.getExtendJson(), VipZeroOrderExtendJson.class))) {
            log.warn("\u8ba2\u5355: {} \u7684vip0\u5143\u8d2d\u62d3\u5c55\u4fe1\u606f\u4e3a\u7a7a \u52a9\u529b\u5931\u8d25", (Object)orderInfoBean.getOrderSn());
            return false;
        }
        Date now = new Date();
        orderInfoBean.setVipPurchaseCommission(json.getVipPurchaseCommission());
        orderInfoBean.setPurchaseCommission(json.getPurchaseCommission());
        orderInfoBean.setParentCommission(json.getParentCommission());
        orderInfoBean.setGrandparentCommission(json.getGrandparentCommission());
        orderInfoBean.setModifyTime(now);
        orderInfoBean.setCreateTime(null);
        this.orderInfoMapper.updateByPrimaryKeySelective(orderInfoBean);
        List orderProfitBeans = this.orderProfitMapper.listByOrderId(orderInfoBean.getId());
        OrderProfitBean profitBean = new OrderProfitBean();
        profitBean.setModifyTime(now);
        orderProfitBeans.forEach(p -> {
            profitBean.setId(p.getId());
            switch (p.getType()) {
                case "PURCHASE": {
                    profitBean.setProfitAmount(orderInfoBean.getPurchaseCommission());
                    this.purchaseInfoRecode(p.getUserId(), false, orderInfoBean, orderInfoBean.getVipPurchaseCommission(), true, true);
                    break;
                }
                case "PARENT": {
                    profitBean.setProfitAmount(orderInfoBean.getParentCommission());
                    this.superiorInfoRecode(p.getUserId(), orderInfoBean, false);
                    break;
                }
                case "GRANDPARENT": {
                    profitBean.setProfitAmount(orderInfoBean.getGrandparentCommission());
                    this.superiorInfoRecode(p.getUserId(), orderInfoBean, false);
                    break;
                }
                default: {
                    log.warn("\u8ba2\u5355\u53f7: {} \u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684vip 0\u5143\u8d2d\u8ba2\u5355", (Object)orderInfoBean.getOrderSn());
                    return;
                }
            }
            this.orderProfitMapper.updateByPrimaryKeySelective(profitBean);
        });
        return true;
    }

    private void superiorInfoRecode(Long superiorUserId, OrderInfoBean orderInfo, boolean isInvalidOrder) {
        if (Objects.nonNull(superiorUserId)) {
            this.addUserAccountByDraftCommission(superiorUserId, orderInfo.getParentCommission(), orderInfo.getOrderSn(), UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);
            this.pushMessageIntegrationService.pushPurchaseContribute(superiorUserId, orderInfo.getParentCommission(), orderInfo.getOrderSn());
            this.addOrderToPopwindows(superiorUserId, Objects.toString(orderInfo.getId()));
        }
    }

    private void topInfoRecode(Long topUserId, OrderInfoBean orderInfo, boolean isInvalidOrder) {
        if (Objects.nonNull(topUserId)) {
            this.addUserAccountByDraftCommission(topUserId, orderInfo.getGrandparentCommission(), orderInfo.getOrderSn(), UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE, isInvalidOrder);
            this.pushMessageIntegrationService.pushShareContribute(topUserId, orderInfo.getGrandparentCommission(), orderInfo.getOrderSn());
            this.addOrderToPopwindows(topUserId, Objects.toString(orderInfo.getId()));
        }
    }

    private void addOrderedRecode(Long userId) {
        KeyGenerator redisKey = CommonCommodityRedisKey.COMMODITY_NEWBIE_USER_SET;
        this.redisSetAdapter.add(redisKey, new Object[]{userId});
        this.taskFacadeService.complete(userId, ActivityFacadeEnum.FIRST_SHOP);
    }

    private void purchaseInfoRecode(Long userId, boolean isInvalidOrder, OrderInfoBean orderInfo, BigDecimal commission, boolean isVip, boolean isPurchaseBySelf) {
        this.addUserAccountByDraftCommission(userId, commission, orderInfo.getOrderSn(), UserCashFlowTypeEnum.PURCHASED_COMMISSION_REBATE, isInvalidOrder);
        if (!isInvalidOrder) {
            this.pushMessageIntegrationService.pushPurchase(userId, commission, orderInfo.getOrderSn());
            if (isVip && Objects.nonNull(orderInfo.getVipPurchaseCommission())) {
                this.vipFacadeService.addVipCommission(userId, orderInfo.getVipPurchaseCommission().subtract(orderInfo.getPurchaseCommission()), 1);
            }
            if (isPurchaseBySelf) {
                this.addOrderedRecode(userId);
            }
        }
        this.addOrderToPopwindows(userId, Objects.toString(orderInfo.getId()));
    }

    public void addOrderToPopwindows(Long userId, String orderId) {
        try {
            if (!userId.equals(0)) {
                KeyGenerator keyGenerator = UserRedisKeyConstant.USER_HAS_NEW_FOLLOW_ORDER.copy().setKey(userId.toString());
                this.redisListAdapter.leftPush(keyGenerator, new Object[]{orderId});
            }
        }
        catch (Exception e) {
            log.error("\u589e\u52a0\u8ba2\u5355\u6253\u5f00\u9875\u9762\u5f39\u7a97\u4fe1\u606f\u5230\u7f13\u5b58\u5931\u8d25" + e.getMessage());
        }
    }

    private void addUserAccountByDraftCommission(Long profitUserId, BigDecimal commissionPrice, String orderId, UserCashFlowTypeEnum userCashFlowTypeEnum, boolean isInvalid) {
        if (isInvalid) {
            return;
        }
        CommissionDraftParam param = new CommissionDraftParam();
        param.setUserId(profitUserId);
        param.setAmount(commissionPrice);
        param.setCashFlowType(userCashFlowTypeEnum);
        param.setRelationId(Long.valueOf(orderId));
        this.accountFacadeService.commissionDraft(param);
    }

    private void recordOrderProfit(OrderInfoBean orderInfo, Long profitUserId, Long userId, ProfitTypeEnum profitType, BigDecimal commissionPrice) {
        OrderProfitBean orderProfitEntity = OrderProfitBean.builder().userId(profitUserId).orderId(orderInfo.getId()).goodsId(orderInfo.getGoodsId()).type(profitType.getCode()).orderSn(orderInfo.getOrderSn()).profitAmount(commissionPrice).orderStatus(orderInfo.getOrderStatus()).orderOwnerUserId(userId.toString()).createTime(new Date()).build();
        this.orderProfitMapper.insertSelective(orderProfitEntity);
    }

    private boolean isPurchaseBySelf(SuperiorDto superiorDtoBySpecialId, SuperiorDto superiorDtoByRelationId) {
        return null != superiorDtoBySpecialId && null != superiorDtoByRelationId && null != superiorDtoBySpecialId.getUserId() && superiorDtoBySpecialId.getUserId().equals(superiorDtoByRelationId.getUserId());
    }
}

