/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.order.common.utils.ApiLimiterFactory;
import com.bxm.fossicker.order.config.OrderInfoProperties;
import com.bxm.fossicker.order.model.param.RelationInfoRspDTO;
import com.bxm.fossicker.order.service.OrderRelationUserService;
import com.bxm.fossicker.user.domain.UserInfoMapper;
import com.bxm.fossicker.user.model.entity.UserInfoBean;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.TbkScPublisherInfoSaveRequest;
import com.taobao.api.request.TopAuthTokenCreateRequest;
import com.taobao.api.response.TbkScPublisherInfoSaveResponse;
import com.taobao.api.response.TopAuthTokenCreateResponse;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderRelationUserServiceImpl
implements OrderRelationUserService {
    private static final Logger log = LogManager.getLogger(OrderRelationUserServiceImpl.class);
    @Resource
    private UserInfoMapper userInfoMapper;
    @Autowired
    private OrderInfoProperties orderInfoProperties;
    @Autowired
    private ApiLimiterFactory reteLlimiterFactory;

    @Override
    public RelationInfoRspDTO relateUserInfo(Long userId, String code) throws ApiException {
        RelationInfoRspDTO result = new RelationInfoRspDTO();
        DefaultTaobaoClient client1 = new DefaultTaobaoClient(this.orderInfoProperties.getTbCommodityUrl(), this.orderInfoProperties.getTbAppkeyWst(), this.orderInfoProperties.getTbAppsecretWst());
        String sessionKey = this.getTbToken(code, (TaobaoClient)client1);
        TbkScPublisherInfoSaveRequest req1 = new TbkScPublisherInfoSaveRequest();
        req1.setOfflineScene("4");
        req1.setOnlineScene("3");
        req1.setInviterCode(this.orderInfoProperties.getSpecialInviteCode());
        req1.setInfoType(Long.valueOf(1L));
        req1.setNote("\u5176\u4ed6");
        TbkScPublisherInfoSaveResponse rsp1 = (TbkScPublisherInfoSaveResponse)client1.execute((TaobaoRequest)req1, sessionKey);
        String result1 = rsp1.getBody();
        JSONObject tbResult1 = JSONObject.parseObject((String)result1);
        JSONObject tbObject1 = JSONObject.parseObject((String)tbResult1.getString("tbk_sc_publisher_info_save_response"));
        JSONObject tbData1 = JSONObject.parseObject((String)tbObject1.getString("data"));
        String specialId = tbData1.getString("special_id");
        DefaultTaobaoClient client3 = new DefaultTaobaoClient(this.orderInfoProperties.getTbCommodityUrl(), this.orderInfoProperties.getTbAppkeyWst(), this.orderInfoProperties.getTbAppsecretWst());
        TbkScPublisherInfoSaveRequest req3 = new TbkScPublisherInfoSaveRequest();
        req3.setOfflineScene("4");
        req3.setOnlineScene("3");
        req3.setInviterCode(this.orderInfoProperties.getRelationInviteCode());
        req3.setInfoType(Long.valueOf(1L));
        req3.setNote("\u5176\u4ed6");
        TbkScPublisherInfoSaveResponse rsp3 = (TbkScPublisherInfoSaveResponse)client3.execute((TaobaoRequest)req3, sessionKey);
        String result3 = rsp3.getBody();
        JSONObject tbResult3 = JSONObject.parseObject((String)result3);
        JSONObject tbObject3 = JSONObject.parseObject((String)tbResult3.getString("tbk_sc_publisher_info_save_response"));
        if (tbObject3 == null) {
            JSONObject tbOjectError = JSONObject.parseObject((String)tbResult3.getString("error_response"));
            String errorMsg = tbOjectError.getString("sub_msg");
            result.setOk(false);
            result.setDesc(errorMsg);
            log.warn("\u7ed1\u5b9a\u5931\u8d25\uff0c\u9519\u8bef\u6d88\u606f\uff1a{},userId:{},code:{}", (Object)tbOjectError.toString(), (Object)userId, (Object)code);
            return result;
        }
        JSONObject tbData3 = JSONObject.parseObject((String)tbObject3.getString("data"));
        String relationId = tbData3.getString("relation_id");
        RelationInfoRspDTO rd = this.isBandTB(userId);
        if (rd.isOk()) {
            if (Objects.equals(rd.getRelationId(), relationId)) {
                log.warn("\u7ed1\u5b9a\u6210\u529f\uff0c\u4f46\u8fdb\u884c\u4e86\u91cd\u590d\u7ed1\u5b9a, userId: {}, code: {}", (Object)userId, (Object)code);
                result.setOk(true);
                result.setRelationId(rd.getRelationId());
                result.setDesc("\u7ed1\u5b9a\u6210\u529f");
                return result;
            }
            log.warn("\u7ed1\u5b9a\u5931\u8d25\uff0c\u91cd\u590d\u8fdb\u884c\u7ed1\u5b9a,userId:{},code:{}", (Object)userId, (Object)code);
            result.setOk(false);
            result.setRelationId(rd.getRelationId());
            result.setDesc("\u5df2\u7ed1\u5b9a\u8fc7\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u7ed1\u5b9a\uff1b\u5df2\u63d0\u4f9b\u67e5\u8be2\u662f\u5426\u7ed1\u5b9a\u63a5\u53e3");
            return result;
        }
        if (StringUtils.isBlank((String)relationId)) {
            log.warn("\u7ed1\u5b9a\u5931\u8d25\uff0c\u6dd8\u5b9dAPI\u8fd4\u56derelationId\u4e3a\u7a7a,userId:{},code:{}", (Object)userId, (Object)code);
            result.setOk(false);
            result.setDesc("\u7ed1\u5b9a\u5931\u8d25");
        } else if (this.relationIdIsBind(relationId)) {
            log.warn("\u7ed1\u5b9a\u5931\u8d25\uff0c\u6dd8\u5b9d\u8d26\u53f7\u5df2\u7ed1\u5b9a\u5176\u4ed6\u7528\u6237\u8d26\u53f7,userId:{},code:{}", (Object)userId, (Object)code);
            result.setOk(false);
            result.setDesc("\u8be5\u6dd8\u5b9d\u8d26\u53f7\u5df2\u6388\u6743\u5176\u4ed6\u7528\u6237");
        } else {
            this.userInfoMapper.updateSetTBrelation(userId, relationId, specialId);
            result.setOk(true);
            result.setRelationId(relationId);
            result.setDesc("\u7ed1\u5b9a\u6210\u529f");
        }
        return result;
    }

    private String getTbToken(String code, TaobaoClient client) throws ApiException {
        JSONObject token;
        String sessionKey = "";
        TopAuthTokenCreateRequest req = new TopAuthTokenCreateRequest();
        req.setCode(code);
        TopAuthTokenCreateResponse rsp = (TopAuthTokenCreateResponse)client.execute((TaobaoRequest)req);
        if (rsp != null && rsp.isSuccess() && StringUtils.isNotBlank((String)rsp.getTokenResult()) && (token = JSONObject.parseObject((String)rsp.getTokenResult())).containsKey((Object)"access_token")) {
            sessionKey = token.getString("access_token");
        }
        if (log.isDebugEnabled()) {
            log.debug("token:[{}]", (Object)sessionKey);
        }
        return sessionKey;
    }

    @Override
    public RelationInfoRspDTO isBandTB(Long userId) {
        UserInfoBean userInfo = this.userInfoMapper.selectByPrimaryKey(userId);
        RelationInfoRspDTO result = new RelationInfoRspDTO();
        if (userInfo == null) {
            result.setOk(false);
            result.setDesc("\u7528\u6237\u4e0d\u5b58\u5728");
            return result;
        }
        if (StringUtils.isNotBlank((String)userInfo.getTbkRelationId())) {
            result.setOk(true);
            result.setRelationId(userInfo.getTbkRelationId());
            result.setDesc("\u5df2\u7ed1\u5b9a");
        } else {
            result.setOk(false);
            result.setDesc("\u672a\u7ed1\u5b9a");
        }
        return result;
    }

    private boolean relationIdIsBind(String relationId) {
        UserInfoBean userInfo = this.userInfoMapper.selectByRelationId(relationId);
        return userInfo != null;
    }
}

