/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.enums.PrivacyTypeEnum;
import com.bxm.fossicker.enums.UserJudgeMarkerEnum;
import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.facade.PushFacadeService;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.order.config.OrderConfigProperties;
import com.bxm.fossicker.order.config.VipZeroOrderProperties;
import com.bxm.fossicker.order.domain.OrderExtendInfoExtendMapper;
import com.bxm.fossicker.order.domain.OrderInfoMapper;
import com.bxm.fossicker.order.domain.OrderProfitMapper;
import com.bxm.fossicker.order.model.constant.OrderExtendType;
import com.bxm.fossicker.order.model.constant.TbOrderType;
import com.bxm.fossicker.order.model.dto.VipZeroOrderExtendJson;
import com.bxm.fossicker.order.model.entity.OrderExtendInfoBean;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.entity.OrderProfitBean;
import com.bxm.fossicker.order.model.entity.UserOrderExtendInfoBean;
import com.bxm.fossicker.order.model.entity.UserOrderInfoBean;
import com.bxm.fossicker.order.model.param.UserOrderParam;
import com.bxm.fossicker.order.model.param.UserOwnOrderWithExtendInfoParam;
import com.bxm.fossicker.order.model.vo.FriendOrderVO;
import com.bxm.fossicker.order.model.vo.UserOrderInfoVO;
import com.bxm.fossicker.order.service.OrderService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.SuperiorDto;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Resource
    private OrderInfoMapper orderInfoMapper;
    @Resource
    private OrderProfitMapper orderProfitMapper;
    @Resource
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private OrderExtendInfoExtendMapper orderExtendInfoMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private OrderConfigProperties orderConfigProperties;
    @Resource
    private VipZeroOrderProperties vipZeroOrderProperties;
    @Resource
    private PushFacadeService pushFacadeService;

    @Override
    public List<UserOrderInfoVO> getUserOrder(UserOrderParam param) {
        if (param.getUserId() == null || param.getUserId() == 0L) {
            log.warn("user id is null");
            return Lists.newArrayList();
        }
        Page page = PageHelper.startPage((Object)param).doSelectPage(() -> this.orderProfitMapper.selectByUserIdPageInfo(param));
        List<UserOrderInfoVO> orderInfos = page.getResult().stream().map(this::build).collect(Collectors.toList());
        BigDecimal zeroCommission = new BigDecimal("0");
        orderInfos.removeIf(userOrderInfoVO -> zeroCommission.compareTo(userOrderInfoVO.getCommission()) >= 0);
        return orderInfos;
    }

    @Override
    public List<UserOrderExtendInfoBean> selectUserOwnOrderWithExtendInfo(UserOwnOrderWithExtendInfoParam param) {
        Page page = PageHelper.startPage((Object)param).doSelectPage(() -> this.orderExtendInfoMapper.selectUserOwnOrderWithExtendInfo(param));
        return page.getResult();
    }

    @Override
    public Boolean addOrderInfo(OrderInfoBean orderInfoBean, byte commissionType) {
        Integer insertResult;
        boolean result;
        OrderInfoBean orderInfoByOrderId = this.orderInfoMapper.getOrderInfoByOrderId(orderInfoBean.getOrderSn());
        if (null != orderInfoByOrderId) {
            log.info("\u5df2\u6709\u8be5\u8ba2\u5355\u4fe1\u606f,\u4e0d\u518d\u63d2\u5165,\u8ba2\u5355\u53f7\u4e3a:{}", (Object)orderInfoBean.getOrderSn());
            return false;
        }
        String extendJson = "";
        OrderExtendType orderExtendType = OrderExtendType.getByCommissionType((byte)commissionType);
        if (Objects.equals(OrderExtendType.VIP_ZERO, orderExtendType)) {
            log.info("\u5f53\u524d\u8ba2\u5355: {} \u4e3avip0\u5143\u8d2d\u8ba2\u5355\uff0c\u4fee\u6539\u8ba2\u5355\u4f63\u91d1\u4e3a0", (Object)orderInfoBean.getOrderSn());
            VipZeroOrderExtendJson extendJsonBean = new VipZeroOrderExtendJson();
            extendJsonBean.setVipPurchaseCommission(orderInfoBean.getVipPurchaseCommission());
            extendJsonBean.setPurchaseCommission(orderInfoBean.getPurchaseCommission());
            extendJsonBean.setParentCommission(orderInfoBean.getParentCommission());
            extendJsonBean.setGrandparentCommission(orderInfoBean.getGrandparentCommission());
            extendJson = JSON.toJSONString((Object)extendJsonBean);
            orderInfoBean.setVipPurchaseCommission(BigDecimal.ZERO);
            orderInfoBean.setPurchaseCommission(BigDecimal.ZERO);
            orderInfoBean.setParentCommission(BigDecimal.ZERO);
            orderInfoBean.setGrandparentCommission(BigDecimal.ZERO);
        }
        boolean bl = result = null != (insertResult = this.orderInfoMapper.insertOrderInfo(orderInfoBean)) && 1 == insertResult;
        if (result) {
            OrderExtendInfoBean extendInfo = this.addOrderExtendInfo(orderInfoBean, orderExtendType, extendJson);
            this.pushZeroCommodityOrderSyncMsg(orderInfoBean, extendInfo, orderExtendType);
        }
        return result;
    }

    private void pushZeroCommodityOrderSyncMsg(OrderInfoBean orderInfoBean, OrderExtendInfoBean extendInfo, OrderExtendType orderExtendType) {
        if (Objects.equals(OrderExtendType.VIP_ZERO, orderExtendType)) {
            this.pushFacadeService.push(MixPushParam.builder().addStrategy(PushStrategyEnum.MAX_ATTEMPT).userId(extendInfo.getOwnerUserId()).notifyType(NotifyEnum.ZERO_COMMODITY_ORDER_SYNC).addExtend(NotifyParamEnum.TIME, (Object)DateUtils.formatDateTime((Date)extendInfo.getCreateTime())).addExtend(NotifyParamEnum.TITLE, (Object)orderInfoBean.getGoodsName()).addExtend(NotifyParamEnum.ORDER_NUM, (Object)orderInfoBean.getOrderSn()).addExtend(NotifyParamEnum.AMOUNT, (Object)orderInfoBean.getVipPurchaseCommission()).build());
        }
    }

    private OrderExtendInfoBean addOrderExtendInfo(OrderInfoBean orderInfoBean, OrderExtendType orderExtendType, String extendJson) {
        SuperiorDto superiorDtoBySpecialId;
        OrderExtendInfoBean infoBean = new OrderExtendInfoBean();
        Date now = new Date();
        infoBean.setId(this.sequenceCreater.nextLongId());
        infoBean.setCreateTime(now);
        infoBean.setModifyTime(now);
        infoBean.setTOrderInfoId(orderInfoBean.getId());
        infoBean.setType(Byte.valueOf(orderExtendType.getType()));
        infoBean.setExtendJson(extendJson);
        if (Objects.equals(OrderExtendType.VIP_ZERO, orderExtendType)) {
            infoBean.setVipZeroHelpStatus(Byte.valueOf((byte)0));
            Calendar calendar = Calendar.getInstance();
            calendar.add(11, this.vipZeroOrderProperties.getHelpExpireHour());
            infoBean.setVipZeroHelpExpireTime(calendar.getTime());
        }
        if (Objects.nonNull(superiorDtoBySpecialId = this.userInfoFacadeService.getSuperiorByRelationId(orderInfoBean.getRelationId())) && Objects.nonNull(superiorDtoBySpecialId.getUserId())) {
            infoBean.setOwnerUserId(superiorDtoBySpecialId.getUserId());
        }
        this.orderExtendInfoMapper.insertSelective(infoBean);
        return infoBean;
    }

    @Override
    public List<OrderInfoBean> getOrderSnList(String relationId) {
        return this.orderInfoMapper.getOrderSnList(relationId);
    }

    private UserOrderInfoVO build(UserOrderInfoBean userOrderInfoBean) {
        UserOrderInfoVO info = UserOrderInfoVO.builder().commission(userOrderInfoBean.getCommission()).goodsId(userOrderInfoBean.getGoodsId()).goodsName(userOrderInfoBean.getGoodsName()).orderSn(userOrderInfoBean.getOrderSn()).goodsFirstImg(userOrderInfoBean.getImgUrl()).orderStatus(userOrderInfoBean.getOrderStatus()).orderTypeName(this.profitTypeToOrderType(userOrderInfoBean.getType())).payPrice(userOrderInfoBean.getPayPrice()).source(userOrderInfoBean.getSource()).sourceOrderCreateTime(userOrderInfoBean.getSourceOrderCreateTime()).orderType(TbOrderType.getTypeEnum((String)userOrderInfoBean.getTbOrderType())).build();
        if (Objects.equals(userOrderInfoBean.getTbOrderType(), TbOrderType.ELE.getType())) {
            info.setGoodsFirstImg(this.orderConfigProperties.getEleOrderImgUrl());
        } else {
            FriendOrderVO friendOrderVO = this.friendsOrder(userOrderInfoBean);
            if (Objects.nonNull(friendOrderVO)) {
                info.setFriendNick(friendOrderVO.getFriendNick());
                info.setImgUrl(friendOrderVO.getImgUrl());
                info.setCoupon(friendOrderVO.getCoupon());
                info.setType(friendOrderVO.getType());
                info.setFriendCommission(friendOrderVO.getCommission());
                info.setFriendOrder(this.getFriendOrder(userOrderInfoBean.getType()));
            }
        }
        return info;
    }

    private String profitTypeToOrderType(String profitType) {
        String orderTypeName;
        switch (profitType.toUpperCase()) {
            case "PURCHASE": {
                orderTypeName = "\u81ea\u8d2d";
                break;
            }
            case "PARENT": 
            case "GRANDPARENT": {
                orderTypeName = "\u597d\u53cb";
                break;
            }
            case "SHARE": {
                orderTypeName = "\u5206\u4eab";
                break;
            }
            default: {
                orderTypeName = "\u672a\u5b9a\u4e49";
            }
        }
        return orderTypeName;
    }

    private FriendOrderVO friendsOrder(UserOrderInfoBean userOrderInfoBean) {
        if (userOrderInfoBean.getUserId().equals(userOrderInfoBean.getOrderOwnerUserId())) {
            return null;
        }
        UserInfoDto userInfo = this.userInfoFacadeService.getUserById(userOrderInfoBean.getOrderOwnerUserId());
        if (null == userInfo) {
            log.warn("\u83b7\u53d6\u597d\u53cb\u4fe1\u606f\u4e3a\u7a7a\uff0c\u597d\u53cbID\u4e3a[{}]", (Object)userOrderInfoBean.getOrderOwnerUserId());
            return null;
        }
        FriendOrderVO friendOrderVO = new FriendOrderVO();
        friendOrderVO.setFriendNick(userInfo.getNickName());
        if (StringUtils.isNotBlank((CharSequence)userInfo.getPhoneno()) && Objects.nonNull(userInfo.getJudgeMarker()) && !BitOperatorUtil.getBitAsBoolean((Long)userInfo.getJudgeMarker(), (int)UserJudgeMarkerEnum.SET_NICK_NAME.getIndex())) {
            friendOrderVO.setFriendNick(StringUtils.hideMobile((String)userInfo.getPhoneno()));
        }
        friendOrderVO.setImgUrl(userInfo.getHeadImg());
        if (Objects.isNull(userInfo.getJudgeMarker()) || !BitOperatorUtil.getBitAsBoolean((Long)userInfo.getJudgeMarker(), (int)UserJudgeMarkerEnum.SET_USER_ORDER_PRIVACY.getIndex())) {
            friendOrderVO.setType(Integer.valueOf(PrivacyTypeEnum.ENABLE.getCode()));
        } else {
            friendOrderVO.setType(Integer.valueOf(PrivacyTypeEnum.DISABLE.getCode()));
        }
        OrderInfoBean orderInfoByOrderId = this.orderInfoMapper.getOrderInfoByOrderId(userOrderInfoBean.getOrderSn());
        friendOrderVO.setCoupon(orderInfoByOrderId.getCoupon());
        OrderProfitBean profitBean = this.orderProfitMapper.getProfitInfoByUserIdAndOrderSn(userOrderInfoBean.getOrderSn(), userOrderInfoBean.getOrderOwnerUserId());
        friendOrderVO.setCommission(profitBean.getProfitAmount());
        return friendOrderVO;
    }

    private Integer getFriendOrder(String orderUser) {
        if ("PARENT".equals(orderUser) || "GRANDPARENT".equals(orderUser)) {
            return 1;
        }
        return 0;
    }
}

