/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.facade.AdvertPlaceService;
import com.bxm.fossicker.constant.OrderRedisKeyConstant;
import com.bxm.fossicker.order.common.enums.OrderStatusEnum;
import com.bxm.fossicker.order.common.enums.TbOrderStatusEnum;
import com.bxm.fossicker.order.config.OrderInfoProperties;
import com.bxm.fossicker.order.domain.OrderInfoMapper;
import com.bxm.fossicker.order.domain.OrderProfitMapper;
import com.bxm.fossicker.order.facade.service.SynchronizeOrderService;
import com.bxm.fossicker.order.model.dto.TbOrderPageInfo;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.enums.OrderTypeEnum;
import com.bxm.fossicker.order.model.vo.OrderInfoForQuartz;
import com.bxm.fossicker.order.service.OrderSyncService;
import com.bxm.fossicker.order.service.external.TbOrderService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.SuperiorDto;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.CommissionCancelParam;
import com.bxm.fossicker.user.facade.param.CommissionRebateParam;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderSynchronServiceImpl
implements SynchronizeOrderService,
OrderSyncService {
    private static final Logger log = LogManager.getLogger(OrderSynchronServiceImpl.class);
    @Resource
    private OrderInfoMapper orderInfoMapper;
    @Resource
    private OrderProfitMapper orderProfitMapper;
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private OrderInfoProperties orderInfoProperties;
    @Autowired
    private TbOrderService tbOrderService;
    @Autowired
    private AdvertPlaceService advertPlaceService;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private VipFacadeService vipFacadeService;

    @Transactional(rollbackFor={Exception.class})
    public void payCashForLastMonthOrder() {
        List list = this.orderInfoMapper.getLastMonthInfo();
        if (list.size() > 0) {
            for (OrderInfoForQuartz orderInfoWithLastMonth : list) {
                log.info(" \u5b9a\u65f6\u8fd4\u4f63 \u8fd4\u4f63\u8ba2\u5355\u4fe1\u606f orderInfo : {}", (Object)JSON.toJSONString((Object)orderInfoWithLastMonth));
                this.orderInfoMapper.updateOrderStatus(orderInfoWithLastMonth.getOrderSn(), OrderStatusEnum.HAVE_SETTLED.getStatus().intValue());
                log.info("\u5b9a\u65f6\u8fd4\u4f63 \u72b6\u6001\u66f4\u6539\u5b8c\u6210");
                CommissionRebateParam param = new CommissionRebateParam();
                param.setUserId(orderInfoWithLastMonth.getUserId());
                param.setAmount(orderInfoWithLastMonth.getAmount());
                param.setRelationId(orderInfoWithLastMonth.getOrderId());
                param.setCashFlowType(this.cashType(orderInfoWithLastMonth.getType()));
                this.accountFacadeService.commissionRebate(param);
                log.info("\u5b9a\u65f6\u8fd4\u4f63 \u8fd4\u4f63\u5b8c\u6210");
            }
        }
    }

    public void synchronOrderStatus() {
        if (!this.orderInfoProperties.getOrderStatusSyncQuartzFlag().booleanValue()) {
            log.info("\u5b9a\u65f6\u5f00\u5173\u672a\u5f00\u542f!");
            return;
        }
        this.syncBefore(OrderTypeEnum.CHANNEL_ORDER.getCode());
    }

    public void synchronGeneralOrderStatus() {
        if (!this.orderInfoProperties.getPullOrderSwitchGeneral().booleanValue()) {
            log.info("\u5b9a\u65f6\u5f00\u5173\u672a\u5f00\u542f!");
            return;
        }
        this.syncBefore(OrderTypeEnum.GENERAL_ORDER.getCode());
    }

    @Override
    public void setSyncOrderStatus(String orderSn, int sourceOwnerOrderStatus) {
        KeyGenerator detailRedisKey = OrderRedisKeyConstant.ORDER_SYNCRONIZE_UPDATE_KEY.copy().appendKey((Object)orderSn);
        this.redisStringAdapter.set(detailRedisKey, (Object)sourceOwnerOrderStatus, 5184000L);
    }

    private void syncBefore(int type) {
        try {
            List orderListAll = this.orderInfoMapper.getOrderInfoByStatus(type);
            ArrayList<OrderInfoBean> orderList = new ArrayList<OrderInfoBean>();
            Date startTime = null;
            if (orderListAll.size() > 0) {
                for (OrderInfoBean orderInfoBean : orderListAll) {
                    Date now = new Date();
                    long betweentDate = (now.getTime() - orderInfoBean.getSourceOrderCreateTime().getTime()) / 86400000L;
                    if (betweentDate >= 30L) {
                        orderList.add(orderInfoBean);
                        continue;
                    }
                    startTime = orderInfoBean.getSourceOrderCreateTime();
                    break;
                }
                Date endTime = ((OrderInfoBean)orderListAll.get(orderListAll.size() - 1)).getSourceOrderCreateTime();
                if (startTime != null) {
                    Date start = startTime = this.time(startTime, -1);
                    while (start.getTime() <= endTime.getTime()) {
                        log.info("start :{}", (Object)start);
                        this.doSynchronizedIn30(start, type);
                        start = this.time(start, 20);
                    }
                }
                this.doSynchronizedOver30(orderList, type);
            }
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u51fa\u9519:", (Throwable)e);
        }
    }

    private void doSynchronizedIn30(Date startTime, int type) throws Exception {
        Date endTime = this.time(startTime, 20);
        this.doLogic(startTime, endTime, 1L, null, type);
    }

    private void doSynchronizedOver30(List<OrderInfoBean> orderList, int type) throws Exception {
        for (OrderInfoBean orderInfoBean : orderList) {
            Date startTime = this.time(orderInfoBean.getSourceOrderCreateTime(), -1);
            Date endTime = this.time(startTime, 2);
            this.doLogic(startTime, endTime, 1L, null, type);
        }
    }

    private void doLogic(Date startTime, Date endTime, Long pageNo, String positionIndex, int type) {
        TbOrderPageInfo<OrderInfoBean> tbResult = this.tbOrderService.pullOrderNew(pageNo, (Long)100L, positionIndex, startTime, endTime, type);
        if (tbResult != null && tbResult.getList().size() > 0) {
            this.updateStatus(tbResult.getList());
            if (tbResult.getHasNext().booleanValue()) {
                this.doLogic(startTime, endTime, tbResult.nextPageNo(), tbResult.getPositionIndex(), type);
            }
        }
    }

    private void updateStatus(List<OrderInfoBean> orderList) {
        for (OrderInfoBean orderInfoBean : orderList) {
            String orderSn = orderInfoBean.getOrderSn();
            int orderStatus = orderInfoBean.getSourceOwnerOrderStatus();
            log.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001 orderSn:{},orderStatus:{}", (Object)orderSn, (Object)orderStatus);
            KeyGenerator detailRedisKey = OrderRedisKeyConstant.ORDER_SYNCRONIZE_UPDATE_KEY.copy().appendKey((Object)orderSn);
            String updateStatus = this.redisStringAdapter.getString(detailRedisKey);
            OrderInfoBean orderInfo = this.orderInfoMapper.getOrderInfoByOrderId(orderSn);
            boolean effectiveOrder = StringUtils.isNotBlank((String)updateStatus) && Integer.parseInt(updateStatus) != orderStatus || StringUtils.isBlank((String)updateStatus) && orderInfo != null && orderInfo.getSourceOwnerOrderStatus() != TbOrderStatusEnum.INVALID.getStatus().intValue();
            if (!effectiveOrder) continue;
            if (orderStatus == TbOrderStatusEnum.INVALID.getStatus()) {
                this.updateStatusAndCommission(orderSn, orderInfoBean);
            } else {
                this.orderInfoMapper.updateSourceOrderStatus(orderSn, orderStatus);
                if (!Objects.isNull(orderInfo) && orderInfo.getSourceOwnerOrderStatus() == TbOrderStatusEnum.HAVA_PAID.getStatus().intValue() && this.orderInfoProperties.getActivateCallbackFlag().booleanValue()) {
                    this.advertPlaceService.checkAndsendOrderToBxmAdvert(orderInfo.getId(), orderInfo.getPid());
                    log.info("\u540c\u6b65\u8ba2\u5355\u72b6\u6001 \u56de\u8c03\u5e7f\u544a\u6548\u679c\u76d1\u63a7\u5b8c\u6210 \u8ba2\u5355\u53f7\uff1a{}  pid : {}  \u72b6\u6001\uff1a{}", (Object)orderInfo.getOrderSn(), (Object)orderInfo.getPid(), (Object)orderInfo.getSourceOwnerOrderStatus());
                }
            }
            this.redisStringAdapter.set(detailRedisKey, (Object)orderStatus, 5184000L);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatusAndCommission(String orderSn, OrderInfoBean orderInfoBean) {
        this.orderInfoMapper.updateOrderStatus(orderSn, OrderStatusEnum.INVALID.getStatus().intValue());
        this.orderInfoMapper.updateSourceOrderStatus(orderSn, TbOrderStatusEnum.INVALID.getStatus().intValue());
        List infoList = this.orderProfitMapper.getProfitInfo(orderSn);
        if (infoList.size() > 0) {
            for (OrderInfoForQuartz orderInfoForQuartz : infoList) {
                CommissionCancelParam param = new CommissionCancelParam();
                param.setUserId(orderInfoForQuartz.getUserId());
                param.setAmount(orderInfoForQuartz.getAmount());
                param.setRelationId(orderInfoForQuartz.getOrderId());
                param.setCashFlowType(this.cashType(orderInfoForQuartz.getType()));
                this.accountFacadeService.commissionCancel(param);
            }
        }
        OrderInfoBean orderInfo = this.orderInfoMapper.getOrderInfoByOrderId(orderSn);
        SuperiorDto superiorDto = this.userInfoFacadeService.getSuperiorByRelationId(orderInfoBean.getRelationId());
        if (!Objects.isNull(superiorDto) && this.vipFacadeService.isVip(superiorDto.getUserId()) && Objects.nonNull(orderInfo.getVipPurchaseCommission())) {
            this.vipFacadeService.addVipCommission(superiorDto.getUserId(), orderInfo.getVipPurchaseCommission().subtract(orderInfo.getPurchaseCommission()), 0);
        }
    }

    private UserCashFlowTypeEnum cashType(String type) {
        UserCashFlowTypeEnum typeEnum = null;
        switch (type) {
            case "PURCHASE": {
                typeEnum = UserCashFlowTypeEnum.PURCHASED_COMMISSION_REBATE;
                break;
            }
            case "PARENT": {
                typeEnum = UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE;
                break;
            }
            case "GRANDPARENT": {
                typeEnum = UserCashFlowTypeEnum.COMMUNITY_COMMISSION_REBATE;
                break;
            }
            case "SHARE": {
                typeEnum = UserCashFlowTypeEnum.SHARED_COMMISSION_REBATE;
                break;
            }
        }
        return typeEnum;
    }

    private Date time(Date startTime, int minute) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.add(12, minute);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse(sdf.format(calendar.getTime()));
        return date;
    }
}

