/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.facade.AdvertPlaceService;
import com.bxm.fossicker.commodity.facade.CommodityCommissionFacadeService;
import com.bxm.fossicker.commodity.facade.dto.CommissionPlatformFacadeDTO;
import com.bxm.fossicker.constant.OrderRedisKeyConstant;
import com.bxm.fossicker.order.common.enums.OrderStatusEnum;
import com.bxm.fossicker.order.common.enums.TbOrderStatusEnum;
import com.bxm.fossicker.order.config.OrderInfoProperties;
import com.bxm.fossicker.order.domain.OrderInfoMapper;
import com.bxm.fossicker.order.facade.service.PullOrderFacadeService;
import com.bxm.fossicker.order.model.constant.TbOrderType;
import com.bxm.fossicker.order.model.dto.TbOrderPageInfo;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.enums.OrderTypeEnum;
import com.bxm.fossicker.order.model.param.AddOrderHandParam;
import com.bxm.fossicker.order.service.EleTakeOutOrderService;
import com.bxm.fossicker.order.service.OrderCommissionService;
import com.bxm.fossicker.order.service.OrderService;
import com.bxm.fossicker.order.service.OrderSyncService;
import com.bxm.fossicker.order.service.PullOrderService;
import com.bxm.fossicker.order.service.external.TbOrderService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PullOrderServiceImpl
implements PullOrderFacadeService,
PullOrderService {
    private static final Logger log = LoggerFactory.getLogger(PullOrderServiceImpl.class);
    private final Object $lock = new Object[0];
    @Autowired
    private TbOrderService tbOrderService;
    @Autowired
    private OrderCommissionService orderCommissionService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private OrderService orderService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private OrderInfoMapper orderInfoMapper;
    @Autowired
    private CommodityCommissionFacadeService commodityCommissionFacadeService;
    @Autowired
    private OrderInfoProperties orderInfoProperties;
    @Autowired
    private AdvertPlaceService advertPlaceService;
    @Autowired
    private EleTakeOutOrderService eleTakeOutOrderService;
    @Autowired
    private OrderSyncService orderSyncService;
    private static String DEFAULT_PID = "mm_456760114_597650089_109129050070";

    public void pullOrder() {
        if (!this.orderInfoProperties.getPullOrderSwitch().booleanValue()) {
            log.info("\u8ba2\u5355\u62c9\u53d6\u5f00\u5173\u5173\u95ed,\u4e0d\u8fdb\u884c\u62c9\u53d6");
            return;
        }
        KeyGenerator lastTimeKey = OrderRedisKeyConstant.PULL_ORDER_TIME;
        String lastPullTime = this.redisStringAdapter.getString(lastTimeKey);
        DateTimeFormatter sf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        LocalDateTime queryOrderTime = StringUtils.isNotBlank((String)lastPullTime) ? LocalDateTime.parse(lastPullTime, sf) : LocalDateTime.now().minusMinutes(2L);
        this.pullOrderByTime(queryOrderTime, LocalDateTime.now().minusMinutes(1L), lastTimeKey, false, OrderTypeEnum.CHANNEL_ORDER.getCode());
    }

    public void pullOrderByDay() {
        if (!this.orderInfoProperties.getPullOrderDaySwitch().booleanValue()) {
            log.info("\u8ba2\u5355\u62c9\u53d6\u5f00\u5173\u5173\u95ed,\u4e0d\u8fdb\u884c\u62c9\u53d6");
            return;
        }
        log.info("\u5f00\u59cb\u62c9\u53d6\u534a\u5929\u5236\u7684\u8ba2\u5355");
        KeyGenerator lastTimeKey = OrderRedisKeyConstant.PULL_ORDER_TIME_BY_DAY;
        String lastPullTime = this.redisStringAdapter.getString(lastTimeKey);
        DateTimeFormatter sf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        LocalDateTime queryOrderTime = StringUtils.isNotBlank((String)lastPullTime) ? LocalDateTime.parse(lastPullTime, sf) : LocalDateTime.now().minusMinutes(20L);
        this.pullOrderByTime(queryOrderTime, LocalDateTime.now().minusMinutes(3L), lastTimeKey, true, OrderTypeEnum.CHANNEL_ORDER.getCode());
    }

    public void pullGeneralOrder() {
        if (!this.orderInfoProperties.getPullOrderSwitchGeneral().booleanValue()) {
            log.info("\u8ba2\u5355\u62c9\u53d6\u5f00\u5173\u5173\u95ed,\u4e0d\u8fdb\u884c\u62c9\u53d6");
            return;
        }
        KeyGenerator lastTimeKey = OrderRedisKeyConstant.PULL_ORDER_TIME_GENERAL;
        String lastPullTime = this.redisStringAdapter.getString(lastTimeKey);
        DateTimeFormatter sf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        LocalDateTime queryOrderTime = StringUtils.isNotBlank((String)lastPullTime) ? LocalDateTime.parse(lastPullTime, sf) : LocalDateTime.now().minusMinutes(2L);
        this.pullOrderByTime(queryOrderTime, LocalDateTime.now().minusMinutes(1L), lastTimeKey, false, OrderTypeEnum.GENERAL_ORDER.getCode());
    }

    @Override
    public Boolean addOrderByHand(AddOrderHandParam tbOrderInfo) {
        OrderInfoBean orderInfoBean = this.convertOrderInfo(tbOrderInfo);
        return this.handleOrderInfo(orderInfoBean);
    }

    private void pullOrderByTime(LocalDateTime queryOrderTime, LocalDateTime nowTime, KeyGenerator pullOrderTimeKey, Boolean dayFlag, int type) {
        if (queryOrderTime.isAfter(nowTime)) {
            return;
        }
        this.pullOrderByTbNew(queryOrderTime, dayFlag, type);
        LocalDateTime nextQueryOrderTime = dayFlag != false ? queryOrderTime.plusMinutes(20L) : queryOrderTime.plusMinutes(2L);
        this.redisStringAdapter.set(pullOrderTimeKey, (Object)nextQueryOrderTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
        this.pullOrderByTime(nextQueryOrderTime, nowTime, pullOrderTimeKey, dayFlag, type);
    }

    @Override
    public void pullOrderByTbNew(LocalDateTime queryOrderTime, Boolean dayFlag, int type) {
        ZoneId zoneId = ZoneId.systemDefault();
        Date orderStartTime = dayFlag != false ? Date.from(queryOrderTime.atZone(zoneId).toInstant()) : Date.from(queryOrderTime.minusMinutes(15L).atZone(zoneId).toInstant());
        Date orderEndTime = DateUtils.addField((Date)orderStartTime, (int)12, (int)20);
        Long pageSize = 20L;
        TbOrderPageInfo<OrderInfoBean> orderPage = this.tbOrderService.pullOrderNew((Long)1L, pageSize, null, orderStartTime, orderEndTime, type);
        if (null == orderPage) {
            return;
        }
        List orderResultList = orderPage.getList();
        while (orderPage.getHasNext().booleanValue()) {
            orderPage = this.tbOrderService.pullOrderNew(orderPage.nextPageNo(), pageSize, orderPage.getPositionIndex(), orderStartTime, orderEndTime, type);
            orderResultList.addAll(orderPage.getList());
        }
        orderResultList.forEach(this::handleOrderInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean handleOrderInfo(OrderInfoBean orderInfo) {
        Object object = this.$lock;
        synchronized (object) {
            try {
                log.info("\u5904\u7406\u8ba2\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)orderInfo));
                if (Objects.isNull(orderInfo)) {
                    return false;
                }
                if (Objects.equals(orderInfo.getTbOrderType(), TbOrderType.ELE.getType())) {
                    return this.eleTakeOutOrderService.syncOrder(orderInfo);
                }
                OrderInfoBean orderInfoByOrderId = this.orderInfoMapper.getOrderInfoByOrderId(orderInfo.getOrderSn());
                if (null != orderInfoByOrderId) {
                    log.info("\u8ba2\u5355\u53f7: {} \u5df2\u6709\u8be5\u8ba2\u5355\u4fe1\u606f, \u4e0d\u518d\u5904\u7406", (Object)orderInfo.getOrderSn());
                    return false;
                }
                orderInfo.setOrderStatus(OrderStatusEnum.getOrderStatus((Integer)orderInfo.getSourceOwnerOrderStatus()).intValue());
                byte commissionType = 0;
                if (orderInfo.getRelationId() != null && orderInfo.getType() == OrderTypeEnum.CHANNEL_ORDER.getCode()) {
                    CommissionPlatformFacadeDTO platformCommission = this.commodityCommissionFacadeService.getPlatformCommission(Long.valueOf(orderInfo.getGoodsId()), orderInfo.getCommission(), orderInfo.getSpecialId(), orderInfo.getRelationId(), orderInfo.getPayPrice(), orderInfo.getGoodsNum());
                    if (null != platformCommission) {
                        orderInfo.setVipPurchaseCommission(platformCommission.getVipPurchasePrice());
                        orderInfo.setPurchaseCommission(platformCommission.getPurchasePrice());
                        orderInfo.setParentCommission(platformCommission.getParentPrice());
                        orderInfo.setGrandparentCommission(platformCommission.getGrandParentPrice());
                        commissionType = platformCommission.getCommissionType();
                    }
                    orderInfo.setCoupon(this.getOrderCoupon(Long.valueOf(orderInfo.getGoodsId())));
                    Boolean addOrderResult = this.orderService.addOrderInfo(orderInfo, commissionType);
                    if (addOrderResult.booleanValue()) {
                        this.orderSyncService.setSyncOrderStatus(orderInfo.getOrderSn(), orderInfo.getSourceOwnerOrderStatus());
                        return this.orderCommissionService.addCommission(orderInfo.getOrderSn());
                    }
                } else if (orderInfo.getType() == OrderTypeEnum.GENERAL_ORDER.getCode()) {
                    if (orderInfo.getPid().equals(DEFAULT_PID)) {
                        return false;
                    }
                    Boolean addOrderResult = this.orderService.addOrderInfo(orderInfo, (byte)0);
                    if (addOrderResult.booleanValue()) {
                        this.orderSyncService.setSyncOrderStatus(orderInfo.getOrderSn(), orderInfo.getSourceOwnerOrderStatus());
                        if (orderInfo.getSourceOwnerOrderStatus() == TbOrderStatusEnum.HAVA_PAID.getStatus().intValue() && this.orderInfoProperties.getActivateCallbackFlag().booleanValue()) {
                            this.advertPlaceService.checkAndsendOrderToBxmAdvert(orderInfo.getId(), orderInfo.getPid());
                            log.info("\u62c9\u53d6\u8ba2\u5355 \u56de\u8c03\u5e7f\u544a\u6548\u679c\u76d1\u63a7\u5b8c\u6210 \u8ba2\u5355\u53f7\uff1a{}  pid : {}  \u72b6\u6001\uff1a{}", new Object[]{orderInfo.getOrderSn(), orderInfo.getPid(), orderInfo.getSourceOwnerOrderStatus()});
                        }
                        return true;
                    }
                }
                return true;
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u8ba2\u5355\u5931\u8d25", (Throwable)e);
                log.error("\u5904\u7406\u8ba2\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)orderInfo));
                return false;
            }
        }
    }

    private OrderInfoBean convertOrderInfo(AddOrderHandParam tbOrderInfo) {
        StringBuilder httpsPre = new StringBuilder("https");
        OrderInfoBean orderInfo = OrderInfoBean.builder().id(this.sequenceCreater.nextLongId()).goodsId(tbOrderInfo.getItemId().toString()).goodsName(tbOrderInfo.getItemTitle()).relationId(Objects.toString(tbOrderInfo.getRelationId(), null)).specialId(Objects.toString(tbOrderInfo.getSpecialId(), null)).orderSn(Objects.toString(tbOrderInfo.getTradeId(), null)).orderParentSn(Objects.toString(tbOrderInfo.getTradeParentId(), null)).goodsPrice(StringUtils.isBlank((String)tbOrderInfo.getItemPrice()) ? null : new BigDecimal(tbOrderInfo.getItemPrice())).payPrice(StringUtils.isBlank((String)tbOrderInfo.getAlipayTotalPrice()) ? new BigDecimal("0.00") : new BigDecimal(tbOrderInfo.getAlipayTotalPrice())).sourceOrderCreateTime(DateUtils.parseDateTime((String)tbOrderInfo.getTkCreateTime())).sourceOrderEarningTime(DateUtils.parseDateTime((String)tbOrderInfo.getTkEarningTime())).commission(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tbOrderInfo.getPubSharePreFee()) ? null : new BigDecimal(tbOrderInfo.getPubSharePreFee())).sourceOwnerOrderStatus((null == tbOrderInfo.getTkStatus() ? null : Integer.valueOf(tbOrderInfo.getTkStatus().intValue())).intValue()).source("HAND").imgUrl(httpsPre.append(tbOrderInfo.getItemImg()).toString()).pid(tbOrderInfo.getPid()).type(tbOrderInfo.getType()).createTime(new Date()).build();
        Long goodsId = tbOrderInfo.getItemId();
        orderInfo.setOrderStatus(OrderStatusEnum.getOrderStatus((Integer)orderInfo.getSourceOwnerOrderStatus()).intValue());
        CommissionPlatformFacadeDTO platformCommission = this.commodityCommissionFacadeService.getPlatformCommission(goodsId, orderInfo.getCommission(), orderInfo.getSpecialId(), orderInfo.getRelationId(), orderInfo.getPayPrice(), orderInfo.getGoodsNum());
        if (null != platformCommission) {
            orderInfo.setPurchaseCommission(platformCommission.getPurchasePrice());
            orderInfo.setParentCommission(platformCommission.getParentPrice());
            orderInfo.setGrandparentCommission(platformCommission.getGrandParentPrice());
        }
        return orderInfo;
    }

    private BigDecimal getOrderCoupon(Long goodsId) {
        Double couponPrice = this.commodityCommissionFacadeService.getCouponPrice(goodsId);
        if (Objects.isNull(couponPrice)) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(couponPrice);
    }
}

