/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.facade.PushFacadeService;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.order.config.VipZeroOrderProperties;
import com.bxm.fossicker.order.domain.OrderExtendInfoExtendMapper;
import com.bxm.fossicker.order.facade.dto.HelpZeroCommodityOrderDTO;
import com.bxm.fossicker.order.facade.param.HelpZeroCommodityOrderParam;
import com.bxm.fossicker.order.facade.service.VipZeroCommodityFacadeService;
import com.bxm.fossicker.order.model.constant.OrderExtendType;
import com.bxm.fossicker.order.model.dto.VipZeroOrderExtendJson;
import com.bxm.fossicker.order.model.entity.OrderExtendInfoBean;
import com.bxm.fossicker.order.model.entity.UserOrderExtendInfoBean;
import com.bxm.fossicker.order.model.param.ListAllVipZeroOrderParam;
import com.bxm.fossicker.order.model.param.UserIdParam;
import com.bxm.fossicker.order.model.param.UserOwnOrderWithExtendInfoParam;
import com.bxm.fossicker.order.model.vo.UserVipZeroCommodityOrderInfoVO;
import com.bxm.fossicker.order.service.OrderCommissionService;
import com.bxm.fossicker.order.service.OrderService;
import com.bxm.fossicker.order.service.VipZeroCommodityOrderService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class VipZeroCommodityOrderServiceImpl
implements VipZeroCommodityFacadeService,
VipZeroCommodityOrderService {
    private static final Logger log = LoggerFactory.getLogger(VipZeroCommodityOrderServiceImpl.class);
    @Resource
    private OrderService orderService;
    @Resource
    private VipZeroOrderProperties vipZeroOrderProperties;
    @Resource
    private UserInfoFacadeService userInfoFacadeService;
    @Resource
    private OrderExtendInfoExtendMapper orderExtendInfoExtendMapper;
    @Resource
    private OrderCommissionService orderCommissionService;
    @Resource
    private PushFacadeService pushFacadeService;

    @Override
    public List<UserVipZeroCommodityOrderInfoVO> listAll(ListAllVipZeroOrderParam param) {
        UserOwnOrderWithExtendInfoParam infoParam = new UserOwnOrderWithExtendInfoParam();
        BeanUtils.copyProperties((Object)param, (Object)infoParam);
        infoParam.setOrderExtendType(Byte.valueOf(OrderExtendType.VIP_ZERO.getType()));
        List<UserOrderExtendInfoBean> userOrderExtendInfoBeans = this.orderService.selectUserOwnOrderWithExtendInfo(infoParam);
        return userOrderExtendInfoBeans.stream().peek(p -> {
            if (Objects.nonNull(p.getVipZeroHelpExpireTime()) && DateUtils.before((Date)p.getVipZeroHelpExpireTime()) && Objects.nonNull(p.getVipZeroHelpStatus()) && p.getVipZeroHelpStatus() == 0) {
                OrderExtendInfoBean extendInfoBean = new OrderExtendInfoBean();
                Date now = new Date();
                extendInfoBean.setId(p.getExtendId());
                extendInfoBean.setModifyTime(now);
                extendInfoBean.setVipZeroHelpStatus(Byte.valueOf((byte)2));
                this.orderExtendInfoExtendMapper.updateByPrimaryKeySelective(extendInfoBean);
                p.setVipZeroHelpStatus(Byte.valueOf((byte)2));
            }
        }).map(this::build).collect(Collectors.toList());
    }

    private UserVipZeroCommodityOrderInfoVO build(UserOrderExtendInfoBean userOrderExtendInfoBean) {
        VipZeroOrderExtendJson json;
        Long helpExpireSecond = 0L;
        if (Objects.nonNull(userOrderExtendInfoBean.getVipZeroHelpStatus()) && Objects.nonNull(userOrderExtendInfoBean.getExtendCreateTime()) && userOrderExtendInfoBean.getVipZeroHelpStatus() == 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(userOrderExtendInfoBean.getExtendCreateTime());
            calendar.add(11, this.vipZeroOrderProperties.getHelpExpireHour());
            helpExpireSecond = (calendar.getTimeInMillis() - Calendar.getInstance().getTimeInMillis()) / 1000L;
        }
        String helpUserHeadImg = null;
        String helpUserNickName = null;
        if (Objects.nonNull(userOrderExtendInfoBean.getVipZeroHelpStatus()) && userOrderExtendInfoBean.getVipZeroHelpStatus() == 1) {
            UserInfoDto user = this.userInfoFacadeService.getUserById(userOrderExtendInfoBean.getVipZeroHelpUserId());
            helpUserHeadImg = user.getHeadImg();
            helpUserNickName = user.getNickName();
        }
        double commission = 0.0;
        if (StringUtils.isNotBlank((CharSequence)userOrderExtendInfoBean.getExtendJson()) && Objects.nonNull(json = (VipZeroOrderExtendJson)JSON.parseObject((String)userOrderExtendInfoBean.getExtendJson(), VipZeroOrderExtendJson.class))) {
            commission = json.getVipPurchaseCommission().doubleValue();
        }
        return UserVipZeroCommodityOrderInfoVO.builder().goodsFirstImg(userOrderExtendInfoBean.getImgUrl()).goodsId(userOrderExtendInfoBean.getGoodsId()).goodsName(userOrderExtendInfoBean.getGoodsName()).helpExpireSecond(helpExpireSecond).helpUserHeadImg(helpUserHeadImg).helpUserId(userOrderExtendInfoBean.getVipZeroHelpUserId()).helpUserNickName(helpUserNickName).orderSn(userOrderExtendInfoBean.getOrderSn()).status(userOrderExtendInfoBean.getVipZeroHelpStatus()).commission(Double.valueOf(commission)).build();
    }

    @Override
    public boolean canOrderVipZeroCommodity(UserIdParam param) {
        Long count = this.orderExtendInfoExtendMapper.selectUserOwnVipZeroOrderNotHelpExpiredCount(param.getUserId());
        return Objects.isNull(count) || count < 1L;
    }

    public HelpZeroCommodityOrderDTO helpZeroCommodityOrder(HelpZeroCommodityOrderParam param) {
        log.info("\u52a9\u529bvip0\u5143\u8d2d\u8ba2\u5355\uff0c \u52a9\u529b\u4eba: {} \u88ab\u52a9\u529b\u4eba: {}", (Object)param.getUserId(), (Object)param.getSuperiorUserId());
        UserOwnOrderWithExtendInfoParam extendInfoParam = new UserOwnOrderWithExtendInfoParam();
        extendInfoParam.setUserId(param.getSuperiorUserId());
        extendInfoParam.setVipZeroHelpStatus(Byte.valueOf((byte)0));
        extendInfoParam.setOrderExtendType(Byte.valueOf(OrderExtendType.VIP_ZERO.getType()));
        List userOrderExtendInfoBeans = this.orderExtendInfoExtendMapper.selectUserOwnOrderWithExtendInfo(extendInfoParam);
        if (!CollectionUtils.isEmpty((Collection)userOrderExtendInfoBeans)) {
            Date now = new Date();
            for (UserOrderExtendInfoBean orderExtendInfoBean : userOrderExtendInfoBeans) {
                if (!Objects.nonNull(orderExtendInfoBean.getVipZeroHelpExpireTime()) || !DateUtils.after((Date)orderExtendInfoBean.getVipZeroHelpExpireTime()) || !Objects.nonNull(orderExtendInfoBean.getVipZeroHelpStatus()) || orderExtendInfoBean.getVipZeroHelpStatus() != 0 || !this.orderCommissionService.updateVipZeroOrderProfitToSuccess(orderExtendInfoBean.getId())) continue;
                OrderExtendInfoBean infoBean = new OrderExtendInfoBean();
                infoBean.setId(orderExtendInfoBean.getExtendId());
                infoBean.setModifyTime(now);
                infoBean.setVipZeroHelpStatus(Byte.valueOf((byte)1));
                infoBean.setVipZeroHelpUserId(param.getUserId());
                this.orderExtendInfoExtendMapper.updateByPrimaryKeySelective(infoBean);
                this.pushHelpSuccessMsg(orderExtendInfoBean, param.getSuperiorUserId());
                return HelpZeroCommodityOrderDTO.builder().success(Boolean.TRUE).build();
            }
        }
        return HelpZeroCommodityOrderDTO.builder().success(Boolean.FALSE).build();
    }

    private void pushHelpSuccessMsg(UserOrderExtendInfoBean orderInfo, Long userId) {
        this.pushFacadeService.push(MixPushParam.builder().addStrategy(PushStrategyEnum.MAX_ATTEMPT).userId(userId).notifyType(NotifyEnum.ZERO_COMMODITY_ORDER_SUCCESS).addExtend(NotifyParamEnum.TIME, (Object)DateUtils.formatDateTime((Date)orderInfo.getCreateTime())).addExtend(NotifyParamEnum.TITLE, (Object)orderInfo.getGoodsName()).addExtend(NotifyParamEnum.ORDER_NUM, (Object)orderInfo.getOrderSn()).addExtend(NotifyParamEnum.AMOUNT, (Object)orderInfo.getVipPurchaseCommission()).build());
    }
}

