/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.OKHttpService;
import com.bxm.fossicker.order.config.DuoMaiMeituanProperties;
import com.bxm.fossicker.order.model.dto.MeituanOrderDetailInfo;
import com.bxm.fossicker.order.model.dto.MeituanOrderInfo;
import com.bxm.fossicker.order.model.param.QueryMeituanOrderListParam;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MeituanOrderApiService {
    private static final Logger log = LoggerFactory.getLogger(MeituanOrderApiService.class);
    @Autowired
    private OKHttpService okHttpService;
    @Autowired
    private DuoMaiMeituanProperties duoMaiMeituanProperties;
    private static final Map<String, String> HEARDS = Maps.newHashMap();

    public MeituanOrderDetailInfo getMeituanOrderDetailInfo(String orderSn) {
        if (StringUtils.isBlank((CharSequence)orderSn)) {
            log.warn("\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u67e5\u8be2\u7f8e\u56e2\u8ba2\u5355");
            return null;
        }
        try {
            List meituanOrderDetailInfos;
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("hash", this.duoMaiMeituanProperties.getSecret());
            paramMap.put("action", "query_detail");
            paramMap.put("order_sn", orderSn);
            paramMap.put("format", this.duoMaiMeituanProperties.getFormat());
            String result = this.okHttpService.get(this.duoMaiMeituanProperties.getOrderDetailUrl(), (Map)paramMap, HEARDS);
            if (log.isDebugEnabled()) {
                log.debug("\u8bf7\u6c42\u591a\u9ea6\u8054\u76df\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u63a5\u53e3\u8fd4\u56de\u6570\u636e: {}", (Object)result);
            }
            if (StringUtils.isBlank((CharSequence)result) || !result.startsWith("[") || CollectionUtils.isEmpty((Collection)(meituanOrderDetailInfos = JSON.parseArray((String)result, MeituanOrderDetailInfo.class)))) {
                log.warn("\u8bf7\u6c42\u591a\u9ea6\u8054\u76df\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25: {}", (Object)result);
                return null;
            }
            MeituanOrderDetailInfo detailInfo = (MeituanOrderDetailInfo)meituanOrderDetailInfos.get(0);
            log.info("\u6839\u636e\u8ba2\u5355\u53f7: {} \u67e5\u8be2\u8be6\u60c5: {}", (Object)orderSn, (Object)JSON.toJSONString((Object)detailInfo));
            return detailInfo;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u591a\u9ea6\u8054\u76df\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public List<MeituanOrderInfo> queryList(QueryMeituanOrderListParam param) {
        try {
            param.setHash(this.duoMaiMeituanProperties.getSecret());
            Map<String, String> paramMap = this.build(param);
            if (log.isDebugEnabled()) {
                log.debug("\u8bf7\u6c42\u53c2\u6570: {} \u751f\u6210\u7684\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)param), paramMap);
            }
            String res = this.okHttpService.get(this.duoMaiMeituanProperties.getOrderListQueryUrl(), paramMap, HEARDS);
            if (log.isDebugEnabled()) {
                log.debug("\u8bf7\u6c42\u591a\u9ea6\u8054\u76df\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u8fd4\u56de\u6570\u636e: {}", (Object)res);
            }
            if (StringUtils.isBlank((CharSequence)res) || !res.startsWith("[")) {
                return Lists.newArrayList();
            }
            return JSON.parseArray((String)res, MeituanOrderInfo.class);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u591a\u9ea6\u8054\u76df\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u5931\u8d25", (Throwable)e);
            return Lists.newArrayList();
        }
    }

    private Map<String, String> build(QueryMeituanOrderListParam param) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)param));
        HashMap paramMap = Maps.newHashMap();
        jsonObject.forEach((key, value) -> {
            if (StringUtils.isNotBlank((CharSequence)key) && Objects.nonNull(value)) {
                paramMap.put(key, Objects.toString(value));
            }
        });
        return paramMap;
    }
}

