/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl.takeout;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.order.common.enums.TbOrderStatusEnum;
import com.bxm.fossicker.order.config.EleProperties;
import com.bxm.fossicker.order.config.TakeOutOrderCommissionProperties;
import com.bxm.fossicker.order.domain.OrderInfoTakeOutExtendMapper;
import com.bxm.fossicker.order.model.constant.OrderRedisKey;
import com.bxm.fossicker.order.model.constant.TakeOrderStatus;
import com.bxm.fossicker.order.model.constant.TakeOutOrderSource;
import com.bxm.fossicker.order.model.constant.TbOrderType;
import com.bxm.fossicker.order.model.dto.EleOrderAllInfo;
import com.bxm.fossicker.order.model.dto.TbOrderPageInfo;
import com.bxm.fossicker.order.model.entity.OrderInfoBean;
import com.bxm.fossicker.order.model.entity.OrderInfoTakeOut;
import com.bxm.fossicker.order.model.enums.OrderTypeEnum;
import com.bxm.fossicker.order.service.EleTakeOutOrderService;
import com.bxm.fossicker.order.service.external.TbOrderService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.SuperiorDto;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.CommissionCancelParam;
import com.bxm.fossicker.user.facade.param.CommissionDraftParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EleTakeOutOrderServiceImpl
implements EleTakeOutOrderService {
    private static final Logger log = LoggerFactory.getLogger(EleTakeOutOrderServiceImpl.class);
    @Autowired
    private OrderInfoTakeOutExtendMapper orderInfoTakeOutExtendMapper;
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private TbOrderService tbOrderService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private EleProperties eleProperties;
    @Autowired
    private TakeOutOrderCommissionProperties takeOutOrderCommissionProperties;

    @Override
    public boolean syncOrder(OrderInfoBean orderInfo) {
        log.info("\u5904\u7406\u997f\u4e86\u4e48\u8ba2\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)orderInfo));
        OrderInfoTakeOut takeOutOrder = this.orderInfoTakeOutExtendMapper.selectByOrderSn(orderInfo.getOrderSn());
        Date now = new Date();
        if (Objects.nonNull(takeOutOrder)) {
            List sourceOrderInfo;
            if (Objects.equals(orderInfo.getSourceOwnerOrderStatus(), takeOutOrder.getSourceOrderStatus())) {
                log.info("\u8ba2\u5355: {} \u5df2\u5b58\u5728\u5e93\u5185\uff0c\u4e14\u5e93\u5185\u6e90\u72b6\u6001: {} \u4e0e\u5904\u7406\u72b6\u6001\u76f8\u540c\uff0c\u8df3\u8fc7\u5904\u7406", (Object)takeOutOrder.getSourceOrderStatus(), (Object)orderInfo.getSourceOwnerOrderStatus());
                return true;
            }
            if (orderInfo.getSourceOwnerOrderStatus() != 13 && Objects.equals(takeOutOrder.getStatus(), TakeOrderStatus.ALL_SETTLE.getStatus())) {
                log.info("\u8ba2\u5355: {} \u5e93\u5185\u5e73\u53f0\u81ea\u8eab\u72b6\u6001: {} \u4e3a\u5df2\u7ed3\u7b97\uff0c\u8df3\u8fc7\u5904\u7406", (Object)orderInfo.getOrderSn(), (Object)takeOutOrder.getStatus());
                return true;
            }
            String sourceOrderInfoStr = takeOutOrder.getSourceOrderInfoStr();
            if (StringUtils.isBlank((CharSequence)sourceOrderInfoStr) || CollectionUtils.isEmpty((Collection)(sourceOrderInfo = JSON.parseArray((String)sourceOrderInfoStr, EleOrderAllInfo.class)))) {
                sourceOrderInfo = Lists.newArrayList();
            }
            sourceOrderInfo.add(EleOrderAllInfo.builder().orderInfoBean(orderInfo).createTime(now).build());
            OrderInfoTakeOut takeOutOrderForUpdate = this.build(orderInfo);
            takeOutOrderForUpdate.setModifyTime(now);
            takeOutOrderForUpdate.setId(takeOutOrder.getId());
            takeOutOrderForUpdate.setSourceOrderInfoStr(JSON.toJSONString((Object)sourceOrderInfo));
            this.orderInfoTakeOutExtendMapper.updateByPrimaryKeySelective(takeOutOrderForUpdate);
            if (orderInfo.getSourceOwnerOrderStatus() == 13) {
                if (Objects.equals(takeOutOrder.getStatus(), TakeOrderStatus.THIRDPARTY_SETTLE.getStatus())) {
                    CommissionCancelParam param = new CommissionCancelParam();
                    param.setUserId(takeOutOrderForUpdate.getUserId());
                    param.setAmount(takeOutOrderForUpdate.getPurchaseCommission());
                    param.setRelationId(takeOutOrderForUpdate.getId());
                    param.setCashFlowType(UserCashFlowTypeEnum.TAKE_OUT_ORDER_COMMISSION_REBATE);
                    this.accountFacadeService.takeOutCommissionCancel(param);
                } else if (Objects.equals(takeOutOrder.getStatus(), TakeOrderStatus.ALL_SETTLE.getStatus())) {
                    log.info("\u997f\u4e86\u4e48\u8ba2\u5355: {} \u539f\u672c\u5e93\u5185\u72b6\u6001: {} \u6b64\u6b21\u66f4\u65b0\u5e93\u5185\u72b6\u6001: {} \u4e3a\u5df2\u7ed3\u7b97\u4f46\u540e\u671f\u8fdb\u884c\u53d6\u6d88\uff0c\u6dfb\u52a0\u98ce\u63a7\u540d\u5355", new Object[]{takeOutOrder.getOrderSn(), takeOutOrder.getStatus(), takeOutOrderForUpdate.getStatus()});
                    if (Objects.nonNull(takeOutOrder.getUserId())) {
                        this.redisHashMapAdapter.increment(OrderRedisKey.ELE_TAKE_ORDER_CANCEL_TIMES, Objects.toString(takeOutOrder.getUserId()), 1);
                    }
                }
            }
        } else {
            OrderInfoTakeOut takeOutOrderForInsert = this.build(orderInfo);
            takeOutOrderForInsert.setModifyTime(now);
            takeOutOrderForInsert.setCreateTime(now);
            takeOutOrderForInsert.setSourceOrderInfoStr(JSON.toJSONString(Collections.singletonList(EleOrderAllInfo.builder().orderInfoBean(orderInfo).createTime(now).build())));
            Long times = (Long)this.redisHashMapAdapter.get(OrderRedisKey.ELE_TAKE_ORDER_CANCEL_TIMES, Objects.toString(takeOutOrderForInsert.getUserId()), Long.class);
            if (Objects.nonNull(times) && times > (long)this.eleProperties.getMaxCancelTimes().intValue()) {
                log.info("\u7528\u6237: {} \u8d85\u8fc7\u6700\u5927\u53d6\u6d88\u6b21\u6570: {}  \u4e0d\u518d\u8fd4\u4f63", (Object)takeOutOrderForInsert.getUserId(), (Object)this.eleProperties.getMaxCancelTimes());
                takeOutOrderForInsert.setPurchaseCommission(BigDecimal.ZERO);
            }
            if (takeOutOrderForInsert.getPurchaseCommission().compareTo(BigDecimal.ZERO) > 0 && takeOutOrderForInsert.getOrderPrice().compareTo(this.takeOutOrderCommissionProperties.getOverAmt()) >= 0) {
                log.info("\u8d2d\u4e70\u91d1\u989d\u8d85\u8fc7: {} \u6263\u96640.3 \u7528\u4f5c\u91d1\u5e01\u63d0\u73b0", (Object)this.takeOutOrderCommissionProperties.getOverAmt());
                takeOutOrderForInsert.setPurchaseCommission(takeOutOrderForInsert.getPurchaseCommission().subtract(this.takeOutOrderCommissionProperties.getGoldAmt()));
            }
            this.orderInfoTakeOutExtendMapper.insertSelective(takeOutOrderForInsert);
            CommissionDraftParam param = new CommissionDraftParam();
            param.setUserId(takeOutOrderForInsert.getUserId());
            param.setCashFlowType(UserCashFlowTypeEnum.TAKE_OUT_ORDER_COMMISSION_REBATE);
            param.setAmount(takeOutOrderForInsert.getPurchaseCommission());
            param.setRelationId(takeOutOrderForInsert.getId());
            this.accountFacadeService.takeOutCommissionDraft(param);
        }
        return true;
    }

    @Override
    public void syncOrderStatusDays() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.minusDays(this.eleProperties.getSyncCreateOrderBeforeDays().longValue());
        start = LocalDateTime.of(start.getYear(), start.getMonth(), start.getDayOfMonth(), 0, 0, 0, 0);
        LocalDateTime end = now.minusDays(1L);
        end = LocalDateTime.of(end.getYear(), end.getMonth(), end.getDayOfMonth(), 23, 59, 59, 999);
        while (start.isBefore(end)) {
            LocalDateTime localDateTime = start;
            start = start.plusHours(1L);
            this.syncOrderStatus(localDateTime, start);
        }
    }

    @Override
    public void syncOrderStatus(LocalDateTime orderStartTime, LocalDateTime orderEndTime) {
        TbOrderPageInfo<OrderInfoBean> tbOrderPageInfo;
        Long pageNo = 1L;
        String positionIndex = null;
        do {
            log.info("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f: orderStartTime :{} orderEndTime: {}, pageNo: {} positionIndex: {}", new Object[]{orderStartTime, orderEndTime, pageNo, positionIndex});
            tbOrderPageInfo = this.tbOrderService.pullOrderNew(pageNo, (Long)20L, positionIndex, orderStartTime, orderEndTime, OrderTypeEnum.CHANNEL_ORDER.getCode());
            if (Objects.isNull(tbOrderPageInfo)) break;
            if (!CollectionUtils.isEmpty((Collection)tbOrderPageInfo.getList())) {
                tbOrderPageInfo.getList().stream().filter(p -> Objects.equals(p.getTbOrderType(), TbOrderType.ELE.getType())).forEach(this::syncOrderStatus);
            }
            positionIndex = tbOrderPageInfo.getPositionIndex();
            pageNo = tbOrderPageInfo.getPageNo();
        } while (tbOrderPageInfo.getHasNext().booleanValue());
    }

    @Override
    public void syncOrderStatus(OrderInfoBean orderInfo) {
        log.info("\u66f4\u65b0\u8ba2\u5355: {} \u72b6\u6001", (Object)orderInfo.getOrderSn());
        try {
            List sourceOrderInfo;
            OrderInfoTakeOut takeOutOrder = this.orderInfoTakeOutExtendMapper.selectByOrderSn(orderInfo.getOrderSn());
            if (Objects.isNull(takeOutOrder)) {
                log.info("\u8ba2\u5355: {} \u4e0d\u5b58\u5728\u5e93\u4e2d\uff0c\u8fdb\u884c\u5165\u5e93\u64cd\u4f5c", (Object)orderInfo.getOrderSn());
                this.syncOrder(orderInfo);
                return;
            }
            if (Objects.equals(orderInfo.getSourceOwnerOrderStatus(), takeOutOrder.getSourceOrderStatus())) {
                log.info("\u8ba2\u5355: {}\u5df2\u5b58\u5728\u5e93\u5185\uff0c\u4e14\u5e93\u5185\u6e90\u72b6\u6001: {} \u76f8\u540c\uff0c\u8df3\u8fc7\u5904\u7406", (Object)orderInfo.getOrderSn(), (Object)orderInfo.getSourceOwnerOrderStatus());
                return;
            }
            log.info(" \u8ba2\u5355\u539f\u672c\u4fe1\u606f: {}, \u6b64\u6b21\u66f4\u65b0\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)takeOutOrder), (Object)JSON.toJSONString((Object)takeOutOrder));
            Date now = new Date();
            String sourceOrderInfoStr = takeOutOrder.getSourceOrderInfoStr();
            if (StringUtils.isBlank((CharSequence)sourceOrderInfoStr) || CollectionUtils.isEmpty((Collection)(sourceOrderInfo = JSON.parseArray((String)sourceOrderInfoStr, EleOrderAllInfo.class)))) {
                sourceOrderInfo = Lists.newArrayList();
            }
            sourceOrderInfo.add(EleOrderAllInfo.builder().createTime(now).orderInfoBean(orderInfo).build());
            OrderInfoTakeOut takeOutOrderForUpdate = new OrderInfoTakeOut();
            takeOutOrderForUpdate.setId(takeOutOrder.getId());
            takeOutOrderForUpdate.setModifyTime(now);
            takeOutOrderForUpdate.setSourceOrderStatus(Integer.valueOf(orderInfo.getSourceOwnerOrderStatus()));
            takeOutOrderForUpdate.setStatus(Byte.valueOf(this.getOrderStatus(orderInfo.getSourceOwnerOrderStatus()).getStatus()));
            this.orderInfoTakeOutExtendMapper.updateByPrimaryKeySelective(takeOutOrderForUpdate);
            if (orderInfo.getSourceOwnerOrderStatus() == TbOrderStatusEnum.INVALID.getStatus().intValue()) {
                if (Objects.equals(takeOutOrder.getStatus(), TakeOrderStatus.ALL_SETTLE.getStatus())) {
                    log.info("\u997f\u4e86\u4e48\u8ba2\u5355: {} \u539f\u672c\u72b6\u6001: {} \u6b64\u6b21\u66f4\u65b0\u72b6\u6001: {} \u4e3a\u5df2\u7ed3\u7b97\u4f46\u540e\u671f\u8fdb\u884c\u53d6\u6d88\uff0c\u6dfb\u52a0\u98ce\u63a7\u540d\u5355", new Object[]{takeOutOrder.getOrderSn(), takeOutOrder.getStatus(), takeOutOrderForUpdate.getStatus()});
                    if (Objects.nonNull(takeOutOrder.getUserId())) {
                        this.redisHashMapAdapter.increment(OrderRedisKey.ELE_TAKE_ORDER_CANCEL_TIMES, Objects.toString(takeOutOrder.getUserId()), 1);
                    }
                } else {
                    log.info("\u997f\u4e86\u4e48\u8ba2\u5355\u53f7: {} \u53d6\u6d88\u4f63\u91d1\u7ed3\u7b97: {}", (Object)orderInfo.getOrderSn(), (Object)orderInfo.getPurchaseCommission());
                    CommissionCancelParam param = new CommissionCancelParam();
                    param.setUserId(takeOutOrder.getUserId());
                    param.setAmount(takeOutOrder.getPurchaseCommission());
                    param.setRelationId(takeOutOrder.getId());
                    param.setCashFlowType(UserCashFlowTypeEnum.TAKE_OUT_ORDER_COMMISSION_REBATE);
                    this.accountFacadeService.takeOutCommissionCancel(param);
                }
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u8ba2\u5355: {} \u72b6\u6001\u5931\u8d25", (Object)orderInfo.getOrderSn(), (Object)e);
        }
    }

    private OrderInfoTakeOut build(OrderInfoBean orderInfo) {
        SuperiorDto superiorDtoBySpecialId = this.userInfoFacadeService.getSuperiorBySpecialId(orderInfo.getSpecialId());
        SuperiorDto superiorDtoByRelationId = this.userInfoFacadeService.getSuperiorByRelationId(orderInfo.getRelationId());
        Long userId = null;
        if (Objects.nonNull(superiorDtoByRelationId)) {
            userId = superiorDtoByRelationId.getUserId();
        }
        boolean purchaseBySelf = this.isPurchaseBySelf(superiorDtoBySpecialId, superiorDtoByRelationId);
        BigDecimal purchaseCommission = orderInfo.getPayPrice().multiply(this.takeOutOrderCommissionProperties.getEle().getCommonCommissionPurchaseRateForPayPrice()).setScale(2, RoundingMode.DOWN);
        OrderInfoTakeOut takeOutOrder = new OrderInfoTakeOut();
        takeOutOrder.setId(this.sequenceCreater.nextLongId());
        takeOutOrder.setGoodsId(orderInfo.getGoodsId());
        takeOutOrder.setGoodsName(orderInfo.getGoodsName());
        takeOutOrder.setOrderSn(orderInfo.getOrderSn());
        takeOutOrder.setGoodsPrice(orderInfo.getGoodsPrice());
        takeOutOrder.setGoodsNum(Integer.valueOf(orderInfo.getGoodsNum().intValue()));
        takeOutOrder.setOrderPrice(orderInfo.getPayPrice());
        takeOutOrder.setSourceOrderStatus(Integer.valueOf(orderInfo.getSourceOwnerOrderStatus()));
        takeOutOrder.setSourceOrderStatusDes("");
        takeOutOrder.setSourceOrderCreateTime(orderInfo.getSourceOrderCreateTime());
        takeOutOrder.setSource(TakeOutOrderSource.ELE.toString());
        takeOutOrder.setUserId(userId);
        takeOutOrder.setType(Byte.valueOf(purchaseBySelf ? (byte)0 : 1));
        takeOutOrder.setOrderCommission(orderInfo.getCommission());
        takeOutOrder.setPurchaseCommission(purchaseCommission);
        takeOutOrder.setStatus(Byte.valueOf(this.getOrderStatus(orderInfo.getSourceOwnerOrderStatus()).getStatus()));
        takeOutOrder.setRelationId(orderInfo.getRelationId());
        takeOutOrder.setSpecialId(orderInfo.getSpecialId());
        return takeOutOrder;
    }

    private boolean isPurchaseBySelf(SuperiorDto superiorDtoBySpecialId, SuperiorDto superiorDtoByRelationId) {
        return Objects.nonNull(superiorDtoBySpecialId) && Objects.nonNull(superiorDtoByRelationId) && Objects.nonNull(superiorDtoBySpecialId.getUserId()) && Objects.equals(superiorDtoBySpecialId.getUserId(), superiorDtoByRelationId.getUserId());
    }

    private TakeOrderStatus getOrderStatus(int orderStatus) {
        switch (orderStatus) {
            case 12: {
                return TakeOrderStatus.NOT_SETTLE;
            }
            case 3: 
            case 14: {
                return TakeOrderStatus.THIRDPARTY_SETTLE;
            }
        }
        return TakeOrderStatus.INVALID;
    }
}

