/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl.takeout;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.order.config.DuoMaiMeituanProperties;
import com.bxm.fossicker.order.config.TakeOutOrderCommissionProperties;
import com.bxm.fossicker.order.domain.OrderInfoTakeOutExtendMapper;
import com.bxm.fossicker.order.model.constant.TakeOrderStatus;
import com.bxm.fossicker.order.model.constant.TakeOutOrderSource;
import com.bxm.fossicker.order.model.dto.MeituanEuid;
import com.bxm.fossicker.order.model.dto.MeituanOrderAllInfo;
import com.bxm.fossicker.order.model.dto.MeituanOrderDetailInfo;
import com.bxm.fossicker.order.model.dto.MeituanOrderInfo;
import com.bxm.fossicker.order.model.dto.MeituanOrderSourceInfo;
import com.bxm.fossicker.order.model.entity.OrderInfoTakeOut;
import com.bxm.fossicker.order.model.param.QueryMeituanOrderListParam;
import com.bxm.fossicker.order.service.MeituanTakeOutOrderService;
import com.bxm.fossicker.order.service.impl.api.MeituanOrderApiService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.CommissionCancelParam;
import com.bxm.fossicker.user.facade.param.CommissionDraftParam;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MeituanTakeOutOrderServiceImpl
implements MeituanTakeOutOrderService {
    private static final Logger log = LoggerFactory.getLogger(MeituanTakeOutOrderServiceImpl.class);
    @Autowired
    private OrderInfoTakeOutExtendMapper orderInfoTakeOutExtendMapper;
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private MeituanOrderApiService meituanOrderApiService;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private TakeOutOrderCommissionProperties takeOutOrderCommissionProperties;
    @Autowired
    private DuoMaiMeituanProperties duoMaiMeituanProperties;

    @Override
    public Integer orderNotice(MeituanOrderSourceInfo orderInfo) {
        String orderInfoStr = JSON.toJSONString((Object)orderInfo);
        log.info("\u591a\u9ea6\u56de\u8c03\u4fe1\u606f: {}", (Object)orderInfoStr);
        return this.syncOrderInfo((MeituanOrderInfo)JSON.parseObject((String)orderInfoStr, MeituanOrderInfo.class));
    }

    @Override
    public void syncOrderOneDayOnce() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime start = now.minusDays(this.duoMaiMeituanProperties.getSyncCreateOrderBeforeDays().longValue());
        start = LocalDateTime.of(start.getYear(), start.getMonth(), start.getDayOfMonth(), 0, 0, 0, 0);
        LocalDateTime end = now.minusDays(1L);
        end = LocalDateTime.of(end.getYear(), end.getMonth(), end.getDayOfMonth(), 23, 59, 59, 999);
        this.syncOrder(start, end, null, null);
    }

    @Override
    public void syncOrder(LocalDateTime timeFrom, LocalDateTime timeTo, LocalDateTime chargeFrom, LocalDateTime chargeTo) {
        log.info("\u67e5\u8be2\u8ba2\u5355\uff0c timeFrom: {}, timeTo: {}, chargeFrom: {}, chargeTo: {}", new Object[]{timeFrom, timeTo, chargeFrom, chargeTo});
        if (Objects.isNull(timeFrom) && Objects.isNull(timeTo) && Objects.isNull(chargeFrom) && Objects.isNull(chargeTo)) {
            log.warn("\u6ca1\u6709\u6307\u5b9a\u67e5\u8be2\u65f6\u95f4");
            return;
        }
        int pageNo = 0;
        while (true) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            QueryMeituanOrderListParam param = new QueryMeituanOrderListParam();
            if (Objects.nonNull(timeFrom) && Objects.nonNull(timeTo)) {
                param.setTimeFrom(timeFrom.format(formatter));
                param.setTimeTo(timeTo.format(formatter));
            }
            if (Objects.nonNull(chargeFrom) && Objects.nonNull(chargeTo)) {
                param.setChargeFrom(chargeFrom.format(formatter));
                param.setChargeTo(chargeTo.format(formatter));
            }
            param.setLimit(StringUtils.join((Object[])new Serializable[]{Integer.valueOf(pageNo++), ",", this.duoMaiMeituanProperties.getPageSize()}));
            param.setFormat(this.duoMaiMeituanProperties.getFormat());
            List<MeituanOrderInfo> meituanOrderInfos = this.meituanOrderApiService.queryList(param);
            if (CollectionUtils.isEmpty(meituanOrderInfos)) break;
            meituanOrderInfos.forEach(this::syncOrderInfo);
        }
    }

    private Integer syncOrderInfo(MeituanOrderInfo orderInfo) {
        log.info("\u5904\u7406\u7f8e\u56e2\u8ba2\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)orderInfo));
        try {
            MeituanOrderDetailInfo detailInfo;
            if (Objects.isNull(orderInfo)) {
                log.warn("\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5904\u7406\u8ba2\u5355\u4fe1\u606f");
                return -1;
            }
            OrderInfoTakeOut takeOutOrder = this.orderInfoTakeOutExtendMapper.selectByOrderSn(orderInfo.getOrderSn());
            if (Objects.nonNull(takeOutOrder)) {
                if (Objects.equals(orderInfo.getStatus(), takeOutOrder.getSourceOrderStatus())) {
                    log.info("\u8ba2\u5355: {}\u5df2\u5b58\u5728\u5e93\u5185\uff0c\u4e14\u72b6\u6001: {} \u76f8\u540c\uff0c\u8df3\u8fc7\u5904\u7406", (Object)orderInfo.getOrderSn(), (Object)orderInfo.getStatus());
                    return 1;
                }
                if (orderInfo.getStatus() != -1 && (Objects.equals(takeOutOrder.getStatus(), TakeOrderStatus.ALL_SETTLE.getStatus()) || Objects.equals(takeOutOrder.getStatus(), TakeOrderStatus.THIRDPARTY_SETTLE.getStatus()))) {
                    log.info("\u8ba2\u5355: {} \u672c\u5730\u72b6\u6001: {}, \u56de\u8c03\u72b6\u6001: {} \u4e3a\u5df2\u7ed3\u7b97\uff0c\u8df3\u8fc7\u5904\u7406", new Object[]{orderInfo.getOrderSn(), takeOutOrder.getStatus(), orderInfo.getStatus()});
                    return 0;
                }
            }
            if (Objects.isNull(detailInfo = this.meituanOrderApiService.getMeituanOrderDetailInfo(orderInfo.getOrderSn()))) {
                log.warn("\u67e5\u8be2\u8ba2\u5355: {} \u8be6\u60c5\u5931\u8d25\uff0c\u65e0\u6cd5\u6dfb\u52a0\u8ba2\u5355\u6570\u636e", (Object)orderInfo.getOrderSn());
                return -1;
            }
            if (Objects.nonNull(takeOutOrder)) {
                log.info("\u8ba2\u5355: {}\u5df2\u5b58\u5728\uff0c\u6839\u7edd\u6700\u65b0\u6570\u636e\u66f4\u65b0\u5e93\u5185\u4fe1\u606f", (Object)orderInfo.getOrderSn());
                Date now = new Date();
                String sourceOrderInfoStr = takeOutOrder.getSourceOrderInfoStr();
                List meituanOrderAllInfos = StringUtils.isNotBlank((CharSequence)sourceOrderInfoStr) ? JSON.parseArray((String)sourceOrderInfoStr, MeituanOrderAllInfo.class) : Lists.newArrayList();
                meituanOrderAllInfos.add(MeituanOrderAllInfo.builder().orderInfo(orderInfo).detailInfo(detailInfo).createTime(now).build());
                OrderInfoTakeOut takeOutOrderForUpdate = this.build(orderInfo, detailInfo);
                takeOutOrderForUpdate.setId(takeOutOrder.getId());
                takeOutOrderForUpdate.setModifyTime(now);
                takeOutOrderForUpdate.setSourceOrderInfoStr(JSON.toJSONString((Object)meituanOrderAllInfos));
                this.orderInfoTakeOutExtendMapper.updateByPrimaryKeySelective(takeOutOrderForUpdate);
                if (orderInfo.getStatus() == -1) {
                    CommissionCancelParam param = new CommissionCancelParam();
                    param.setUserId(takeOutOrderForUpdate.getUserId());
                    param.setAmount(takeOutOrderForUpdate.getPurchaseCommission());
                    param.setRelationId(takeOutOrderForUpdate.getId());
                    param.setCashFlowType(UserCashFlowTypeEnum.TAKE_OUT_ORDER_COMMISSION_REBATE);
                    this.accountFacadeService.takeOutCommissionCancel(param);
                }
            } else {
                log.info("\u8ba2\u5355: {}\u4e0d\u5b58\u5728\uff0c\u65b0\u589e\u5165\u5e93\u6570\u636e", (Object)orderInfo.getOrderSn());
                Date now = new Date();
                ArrayList sourceOrderInfoStr = Lists.newArrayList((Object[])new MeituanOrderAllInfo[]{MeituanOrderAllInfo.builder().detailInfo(detailInfo).orderInfo(orderInfo).createTime(now).build()});
                OrderInfoTakeOut takeOutOrderForInsert = this.build(orderInfo, detailInfo);
                if (takeOutOrderForInsert.getPurchaseCommission().compareTo(BigDecimal.ZERO) > 0 && takeOutOrderForInsert.getOrderPrice().compareTo(this.takeOutOrderCommissionProperties.getOverAmt()) >= 0) {
                    log.info("\u8d2d\u4e70\u91d1\u989d\u8d85\u8fc7: {} \u6263\u96640.3 \u7528\u4f5c\u91d1\u5e01\u63d0\u73b0", (Object)this.takeOutOrderCommissionProperties.getOverAmt());
                    takeOutOrderForInsert.setPurchaseCommission(takeOutOrderForInsert.getPurchaseCommission().subtract(this.takeOutOrderCommissionProperties.getGoldAmt()));
                }
                takeOutOrderForInsert.setSourceOrderInfoStr(JSON.toJSONString((Object)sourceOrderInfoStr));
                takeOutOrderForInsert.setId(this.sequenceCreater.nextLongId());
                takeOutOrderForInsert.setCreateTime(now);
                takeOutOrderForInsert.setModifyTime(now);
                this.orderInfoTakeOutExtendMapper.insertSelective(takeOutOrderForInsert);
                CommissionDraftParam param = new CommissionDraftParam();
                param.setUserId(takeOutOrderForInsert.getUserId());
                param.setAmount(takeOutOrderForInsert.getPurchaseCommission());
                param.setRelationId(takeOutOrderForInsert.getId());
                param.setCashFlowType(UserCashFlowTypeEnum.TAKE_OUT_ORDER_COMMISSION_REBATE);
                this.accountFacadeService.takeOutCommissionDraft(param);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u7f8e\u56e2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25 \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)orderInfo), (Object)e);
            return -1;
        }
        return 1;
    }

    private OrderInfoTakeOut build(MeituanOrderInfo orderInfo, MeituanOrderDetailInfo detailInfo) {
        MeituanEuid euidObj;
        String euid = orderInfo.getEuid();
        log.warn("\u8ba2\u5355\u53f7: {} \u7684\u7528\u6237\u4fe1\u606f: {}", (Object)orderInfo.getOrderSn(), (Object)euid);
        Long userId = null;
        if (StringUtils.isNotBlank((CharSequence)euid) && Objects.nonNull(euidObj = (MeituanEuid)JSON.parseObject((String)euid, MeituanEuid.class))) {
            userId = euidObj.getUserId();
        }
        Date orderTime = null;
        try {
            orderTime = ((DateFormat)DateUtils.DATE_TIME_FORMAT_THREAD_LOCAL.get()).parse(orderInfo.getOrderTime());
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7f8e\u56e2\u7684\u8ba2\u5355\u521b\u5efa\u65f6\u95f4\u5931\u8d25", (Throwable)e);
        }
        BigDecimal purchaseCommission = orderInfo.getOrdersPrice().multiply(this.takeOutOrderCommissionProperties.getMeituanTakeOutOrder().getCommonCommissionPurchaseRateForPayPrice()).setScale(2, RoundingMode.DOWN);
        OrderInfoTakeOut takeOutOrder = new OrderInfoTakeOut();
        takeOutOrder.setGoodsId(detailInfo.getGoodsId());
        takeOutOrder.setGoodsName(detailInfo.getGoodsName());
        takeOutOrder.setOrderSn(orderInfo.getOrderSn());
        takeOutOrder.setGoodsPrice(detailInfo.getGoodsPrice());
        takeOutOrder.setGoodsNum(detailInfo.getGoodsTa());
        takeOutOrder.setOrderPrice(orderInfo.getOrdersPrice());
        takeOutOrder.setSourceOrderStatus(orderInfo.getStatus());
        takeOutOrder.setSourceOrderStatusDes(detailInfo.getOrderStatus());
        takeOutOrder.setSourceOrderCreateTime(orderTime);
        takeOutOrder.setSource(TakeOutOrderSource.MEITUAN.toString());
        takeOutOrder.setUserId(userId);
        takeOutOrder.setOrderCommission(orderInfo.getSiterCommission());
        takeOutOrder.setPurchaseCommission(purchaseCommission);
        takeOutOrder.setStatus(Byte.valueOf(this.getOrderStatus(orderInfo.getStatus()).getStatus()));
        takeOutOrder.setRelationId(null);
        takeOutOrder.setSpecialId(null);
        takeOutOrder.setSourceOrderEarningTime(null);
        return takeOutOrder;
    }

    private TakeOrderStatus getOrderStatus(Integer status) {
        switch (status) {
            case -1: {
                return TakeOrderStatus.INVALID;
            }
            case 0: 
            case 1: {
                return TakeOrderStatus.NOT_SETTLE;
            }
            case 2: {
                return TakeOrderStatus.THIRDPARTY_SETTLE;
            }
        }
        return TakeOrderStatus.INVALID;
    }
}

