/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl.takeout;

import com.bxm.fossicker.activity.facade.WithdrawAddFacadeService;
import com.bxm.fossicker.message.enums.NotifyEnum;
import com.bxm.fossicker.message.enums.NotifyParamEnum;
import com.bxm.fossicker.message.enums.PushStrategyEnum;
import com.bxm.fossicker.message.facade.PushFacadeService;
import com.bxm.fossicker.message.param.MixPushParam;
import com.bxm.fossicker.order.config.TakeOutOrderCommissionProperties;
import com.bxm.fossicker.order.domain.OrderInfoTakeOutExtendMapper;
import com.bxm.fossicker.order.model.constant.TakeOrderStatus;
import com.bxm.fossicker.order.model.constant.TakeOutOrderSource;
import com.bxm.fossicker.order.model.entity.OrderInfoTakeOut;
import com.bxm.fossicker.order.service.TakeOutOrderCommissionSettleService;
import com.bxm.fossicker.user.facade.AccountFacadeService;
import com.bxm.fossicker.user.facade.enums.UserCashFlowTypeEnum;
import com.bxm.fossicker.user.facade.param.CommissionRebateParam;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TakeOutOrderCommissionSettleServiceImpl
implements TakeOutOrderCommissionSettleService {
    private static final Logger log = LoggerFactory.getLogger(TakeOutOrderCommissionSettleServiceImpl.class);
    @Autowired
    private AccountFacadeService accountFacadeService;
    @Autowired
    private OrderInfoTakeOutExtendMapper orderInfoTakeOutExtendMapper;
    @Autowired
    private TakeOutOrderCommissionProperties takeOutOrderCommissionProperties;
    @Autowired
    private WithdrawAddFacadeService withdrawAddFacadeService;
    @Autowired
    private PushFacadeService pushFacadeService;

    @Override
    public void commissionSettleByOrderTypeAndTimeBefore(TakeOutOrderSource source, Date timeLimit) {
        log.info("\u5916\u5356\u8ba2\u5355\u4f63\u91d1\u7ed3\u7b97\uff0c\u7ed3\u7b97\u6765\u6e90: {} \u622a\u6b62\u65f6\u95f4: {}", (Object)source, (Object)timeLimit);
        List takeOutOrders = this.orderInfoTakeOutExtendMapper.selectBySourceAndTimeLimit(source.toString(), timeLimit, Byte.valueOf(TakeOrderStatus.THIRDPARTY_SETTLE.getStatus()));
        takeOutOrders.stream().filter(Objects::nonNull).forEach(this::commissionSettleByOrder);
    }

    @Override
    public void commissionSettleByOrder(OrderInfoTakeOut takeOutOrder) {
        log.info("\u5916\u5356\u8ba2\u5355: {} userId: {} \u7ed3\u7b97\u4f63\u91d1: {}", new Object[]{takeOutOrder.getOrderSn(), takeOutOrder.getUserId(), takeOutOrder.getPurchaseCommission()});
        try {
            Date now = new Date();
            OrderInfoTakeOut takeOutOrderForUpdate = new OrderInfoTakeOut();
            takeOutOrderForUpdate.setId(takeOutOrder.getId());
            takeOutOrderForUpdate.setModifyTime(now);
            takeOutOrderForUpdate.setStatus(Byte.valueOf(TakeOrderStatus.ALL_SETTLE.getStatus()));
            this.orderInfoTakeOutExtendMapper.updateByPrimaryKeySelective(takeOutOrderForUpdate);
            if (Objects.nonNull(takeOutOrder.getUserId()) && !Objects.equals(takeOutOrder.getUserId(), 0L)) {
                if (takeOutOrder.getPurchaseCommission().compareTo(BigDecimal.ZERO) > 0 && takeOutOrder.getOrderPrice().compareTo(this.takeOutOrderCommissionProperties.getOverAmt()) >= 0) {
                    log.info("\u8d2d\u4e70\u91d1\u989d\u8d85\u8fc7: {} \u589e\u52a0\u91d1\u5e01\u63d0\u73b0\u673a\u4f1a", (Object)this.takeOutOrderCommissionProperties.getOverAmt());
                    this.withdrawAddFacadeService.add(takeOutOrder.getUserId(), Integer.valueOf(5));
                }
                CommissionRebateParam param = new CommissionRebateParam();
                param.setUserId(takeOutOrder.getUserId());
                param.setAmount(takeOutOrder.getPurchaseCommission());
                param.setRelationId(takeOutOrder.getId());
                param.setCashFlowType(UserCashFlowTypeEnum.TAKE_OUT_ORDER_COMMISSION_REBATE);
                this.accountFacadeService.takeOutCommissionRebate(param);
                this.senderNotice(takeOutOrder.getUserId(), Objects.equals(takeOutOrder.getType(), (byte)0) ? NotifyEnum.ELE_PURCHASE_ORDER_SUCCESS : NotifyEnum.ELE_SHARE_ORDER_SUCCESS, takeOutOrder.getOrderSn(), takeOutOrder.getPurchaseCommission());
            }
        }
        catch (Exception e) {
            log.error("\u5916\u5356\u8ba2\u5355: {} \u7ed3\u7b97\u4f63\u91d1\u5931\u8d25", (Object)takeOutOrder.getOrderSn(), (Object)e);
        }
    }

    private void senderNotice(Long userId, NotifyEnum notifyEnum, String orderNo, BigDecimal amount) {
        log.info("\u8ba2\u5355\u7ed3\u7b97\uff0c\u8fdb\u884c\u8fd4\u4f63\u6d88\u606f\u63a8\u9001, userId: {} notifyEnum: {}", (Object)userId, (Object)notifyEnum);
        try {
            this.pushFacadeService.push(MixPushParam.builder().userId(userId).notifyType(notifyEnum).addStrategy(PushStrategyEnum.MAX_ATTEMPT).addExtend(NotifyParamEnum.AMOUNT, (Object)amount).addExtend(NotifyParamEnum.ORDER_NUM, (Object)orderNo).build());
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u7ed3\u7b97\uff0c\u8fdb\u884c\u8fd4\u4f63\u6d88\u606f\u63a8\u9001\u5931\u8d25, userId: {} notifyEnum: {}", new Object[]{userId, notifyEnum, e});
        }
    }
}

