/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.service.impl.takeout;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.facade.CommodityFacadeService;
import com.bxm.fossicker.order.config.DuoMaiMeituanProperties;
import com.bxm.fossicker.order.config.EleProperties;
import com.bxm.fossicker.order.config.OrderConfigProperties;
import com.bxm.fossicker.order.domain.OrderInfoTakeOutExtendMapper;
import com.bxm.fossicker.order.model.constant.TakeOutOrderSource;
import com.bxm.fossicker.order.model.dto.MeituanEuid;
import com.bxm.fossicker.order.model.entity.OrderInfoTakeOut;
import com.bxm.fossicker.order.model.param.TakeOutJumpInfoParam;
import com.bxm.fossicker.order.model.param.TakeOutOrderParam;
import com.bxm.fossicker.order.model.param.UserIdParam;
import com.bxm.fossicker.order.model.vo.EleTaoWord;
import com.bxm.fossicker.order.model.vo.JumpInfo;
import com.bxm.fossicker.order.model.vo.TakeOutOrderInfoVO;
import com.bxm.fossicker.order.service.TakeOutOrderService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.vo.ResponseJson;
import com.bxm.newidea.component.tools.DateUtils;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.taobao.api.request.TbkActivitylinkGetRequest;
import com.taobao.api.response.TbkActivitylinkGetResponse;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TakeOutOrderServiceImpl
implements TakeOutOrderService {
    private static final Logger log = LoggerFactory.getLogger(TakeOutOrderServiceImpl.class);
    @Autowired
    private DuoMaiMeituanProperties duoMaiMeituanProperties;
    @Autowired
    private OrderConfigProperties orderConfigProperties;
    @Autowired
    private CommodityFacadeService commodityFacadeService;
    @Autowired
    private EleProperties eleProperties;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private OrderInfoTakeOutExtendMapper orderInfoTakeOutExtendMapper;

    @Override
    public List<TakeOutOrderInfoVO> getTakeOutList(TakeOutOrderParam param) {
        Page page = PageHelper.startPage((Object)param).doSelectPage(() -> this.orderInfoTakeOutExtendMapper.listByParam(param));
        return page.getResult().stream().map(this::convert).collect(Collectors.toList());
    }

    private TakeOutOrderInfoVO convert(OrderInfoTakeOut takeOut) {
        Date now = new Date();
        TakeOutOrderInfoVO infoVO = new TakeOutOrderInfoVO();
        infoVO.setOrderSn(takeOut.getOrderSn());
        infoVO.setGoodsName(takeOut.getGoodsName());
        infoVO.setGoodsId(takeOut.getGoodsId());
        infoVO.setGoodsFirstImg(this.getGoodsImg(takeOut.getSource()));
        infoVO.setSourceOrderCreateTime(takeOut.getSourceOrderCreateTime());
        infoVO.setPayPrice(takeOut.getOrderPrice());
        infoVO.setCommission(takeOut.getPurchaseCommission());
        infoVO.setOrderTypeName(takeOut.getType().intValue() == 0 ? "\u81ea\u8d2d" : "\u5206\u4eab");
        infoVO.setSource(takeOut.getSource());
        infoVO.setOrderStatus(this.getVOStatus(takeOut.getStatus()));
        infoVO.setTodayOrder(Boolean.valueOf(DateUtils.isSameDay((Date)takeOut.getSourceOrderCreateTime(), (Date)now)));
        return infoVO;
    }

    private String getGoodsImg(String source) {
        return Objects.equals(TakeOutOrderSource.MEITUAN.toString(), source) ? this.orderConfigProperties.getMeituanTakeOutOrderImgUrl() : this.orderConfigProperties.getEleOrderImgUrl();
    }

    private Integer getVOStatus(Byte status) {
        switch (status) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 2;
    }

    @Override
    public ResponseJson<JumpInfo> getJumpInfo(TakeOutJumpInfoParam param) {
        if (Objects.isNull(param.getUserId()) || Objects.isNull(param.getJumpType())) {
            log.warn("\u8bf7\u6c42\u53c2\u6570: {} \u7f3a\u5931", (Object)JSON.toJSONString((Object)param));
            return ResponseJson.badReqeuset((String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        try {
            if (param.getJumpType() == 2) {
                return ResponseJson.ok((Object)this.getMeituanJumpUrl(param.getUserId()));
            }
            String tbkRelationId = this.userInfoFacadeService.getTbkRelationId(param.getUserId());
            if (Objects.isNull(tbkRelationId)) {
                log.warn("userId: {} \u83b7\u53d6relation id \u5931\u8d25", (Object)param.getUserId());
                return ResponseJson.badReqeuset((String)"\u8bf7\u5148\u7ed1\u5b9a\u6dd8\u5b9d");
            }
            return ResponseJson.ok((Object)this.getEleJumpUrl(tbkRelationId, true));
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u7f8e\u56e2\u8df3\u8f6c\u94fe\u63a5\u5931\u8d25 \u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)param), (Object)e);
            return ResponseJson.badReqeuset((String)"\u83b7\u53d6\u5931\u8d25");
        }
    }

    private JumpInfo getEleJumpUrl(String tbkRelationId, boolean switchToProtocol) {
        TbkActivitylinkGetRequest req = new TbkActivitylinkGetRequest();
        req.setAdzoneId(this.eleProperties.getAdZoneId());
        req.setRelationId(tbkRelationId);
        req.setPromotionSceneId(this.eleProperties.getPromotionSceneId());
        TbkActivitylinkGetResponse taoBaoUnion = this.commodityFacadeService.getTaoBaoUnion(req);
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u53c2\u6570: {}, \u83b7\u53d6\u997f\u4e86\u4e48\u8df3\u8f6c\u94fe\u63a5\u8fd4\u56de: {}", (Object)JSON.toJSONString((Object)req), (Object)JSON.toJSONString((Object)taoBaoUnion));
        }
        if (Objects.nonNull(taoBaoUnion) && StringUtils.isNotBlank((String)taoBaoUnion.getData())) {
            String url = taoBaoUnion.getData().replaceAll("\\\\", "");
            if (switchToProtocol) {
                url = StringUtils.isNotBlank((String)url) ? url.replaceAll("https", "qtj://profession/openApp?url=tbopen") : "";
            }
            return JumpInfo.builder().jumpUrl(url).build();
        }
        return null;
    }

    private JumpInfo getMeituanJumpUrl(Long userId) throws URISyntaxException {
        MeituanEuid euid = new MeituanEuid();
        euid.setUserId(userId);
        euid.setTime(new Date());
        URIBuilder uriBuilder = new URIBuilder(this.duoMaiMeituanProperties.getTrackUrl());
        uriBuilder.addParameter("site_id", this.duoMaiMeituanProperties.getSiteId());
        uriBuilder.addParameter("aid", this.duoMaiMeituanProperties.getAid());
        uriBuilder.addParameter("euid", JSON.toJSONString((Object)euid));
        uriBuilder.addParameter("t", this.duoMaiMeituanProperties.getTargetUrl());
        return JumpInfo.builder().jumpUrl(uriBuilder.build().toString()).build();
    }

    @Override
    public ResponseJson<EleTaoWord> getEleTaoWord(UserIdParam param) {
        String tbkRelationId = this.userInfoFacadeService.getTbkRelationId(param.getUserId());
        if (Objects.isNull(tbkRelationId)) {
            log.warn("userId: {} \u83b7\u53d6relation id \u5931\u8d25", (Object)param.getUserId());
            return ResponseJson.badReqeuset((String)"\u8bf7\u5148\u7ed1\u5b9a\u6dd8\u5b9d");
        }
        JumpInfo eleJumpUrl = this.getEleJumpUrl(tbkRelationId, false);
        if (Objects.isNull(eleJumpUrl)) {
            return ResponseJson.badReqeuset((String)"\u83b7\u53d6\u6dd8\u53e3\u4ee4\u5931\u8d25");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u751f\u6210\u6dd8\u53e3\u4ee4, url: {} imgUrl: {}, text: {}", new Object[]{eleJumpUrl.getJumpUrl(), this.eleProperties.getEleTaoWordImgUrl(), this.eleProperties.getEleTaoWordText()});
        }
        return ResponseJson.ok((Object)EleTaoWord.builder().taoWord(this.commodityFacadeService.createTaoWord(eleJumpUrl.getJumpUrl(), this.eleProperties.getEleTaoWordImgUrl(), this.eleProperties.getEleTaoWordText())).build());
    }
}

