/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.order.timer;

import com.bxm.fossicker.order.facade.service.PullOrderFacadeService;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.xxl.job.core.biz.model.ReturnT;
import java.time.LocalDateTime;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullOrderByDayTask
extends AbstractCronTask<String> {
    private static final Logger log = LogManager.getLogger(PullOrderByDayTask.class);
    @Autowired
    private PullOrderFacadeService pullOrderFacadeService;
    @Autowired
    private DistributedLock distributedLock;
    @Autowired
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    @Autowired
    private SequenceCreater sequenceCreater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnT<String> service(String s) {
        log.info("\u62c9\u53d6\u8ba2\u5355\u4fe1\u606f-\u6bcf\u534a\u5929\u542f\u52a8\u4e00\u6b21,\u65f6\u95f4\u4e3a:{}", (Object)LocalDateTime.now());
        String requestId = this.sequenceCreater.nextStringId();
        if (!this.distributedLock.lock("PULL_ORDER_LOCK", requestId)) {
            try {
                log.info("\u672a\u83b7\u53d6\u5230\u5b9a\u65f6\u4efb\u52a1\u9501,\u5ef6\u8fdf\u6267\u884c:{}", (Object)LocalDateTime.now());
                this.scheduledThreadPoolExecutor.schedule(() -> this.pullOrderFacadeService.pullOrderByDay(), 20L, TimeUnit.SECONDS);
                return ReturnT.SUCCESS;
            }
            catch (Exception e) {
                log.error("\u62c9\u53d6\u8ba2\u5355\u4fe1\u606f-\u6bcf\u534a\u5929\u542f\u52a8\u4e00\u6b21\u5ef6\u8fdf\u5904\u7406\u4e1a\u52a1\u91cd\u8bd5\u5931\u8d25", (Throwable)e);
                return ReturnT.FAIL;
            }
        }
        try {
            this.pullOrderFacadeService.pullOrderByDay();
        }
        catch (Exception e) {
            log.error("\u62c9\u53d6\u8ba2\u5355\u4fe1\u606f-\u6bcf\u534a\u5929\u542f\u52a8\u4e00\u6b21,\u5f02\u5e38\u4e3a:", (Throwable)e);
        }
        finally {
            this.distributedLock.unlock("PULL_ORDER_LOCK", requestId);
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "\u62c9\u53d6\u8ba2\u5355\u4fe1\u606f-\u6bcf\u534a\u5929\u542f\u52a8\u4e00\u6b21,\u5bb9\u9519\u5904\u7406";
    }

    public String cron() {
        return "0 0 0,12 * * ?";
    }
}

