/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.bxm.fossicker.thirdpart.facade.config.AlipayProperties;
import com.bxm.fossicker.thirdpart.facade.enums.PayTypeEnum;
import com.bxm.fossicker.thirdpart.facade.service.PayMethodAdapter;
import com.bxm.fossicker.thirdparty.model.param.AlipayNotifyResult;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(hidden=true)
@RestController
@RequestMapping(value={"{version}/pay"})
public class AlipayCallbackController {
    private static final Logger log = LoggerFactory.getLogger(AlipayCallbackController.class);
    private final AlipayProperties alipayProperties;
    private final PayMethodAdapter payMethodAdapter;

    public AlipayCallbackController(AlipayProperties alipayProperties, PayMethodAdapter payMethodAdapter) {
        this.alipayProperties = alipayProperties;
        this.payMethodAdapter = payMethodAdapter;
    }

    @ApiOperation(value="9-09-02 \u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u5904\u7406", notes="")
    @PostMapping(value={"/callback/alipay"})
    public void aliPayNotifyResult(HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter writer = response.getWriter();
            if (this.verifyResult(request).booleanValue()) {
                log.info("\u652f\u4ed8\u56de\u8c03\u901a\u77e5\u9a8c\u8bc1\u6210\u529f");
                this.payMethodAdapter.notifyPay(JSON.toJSONString((Object)this.parseReqeust(request)), PayTypeEnum.ALI_PAY);
                writer.print("success");
            } else {
                log.info("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\u9a8c\u8bc1\u5931\u8d25");
                writer.print("fail");
            }
        }
        catch (AlipayApiException e) {
            log.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u901a\u77e5\uff1a\u6570\u636e\u89e3\u6790\u5f02\u5e38: {}", (Throwable)e);
        }
        catch (IOException ioe) {
            log.error("response\u83b7\u53d6writer\u5f02\u5e38:{}", (Throwable)ioe);
        }
    }

    private AlipayNotifyResult parseReqeust(HttpServletRequest request) {
        return AlipayNotifyResult.builder().outTradeNo(this.getField("out_trade_no", request)).tradeStatus(this.getField("trade_status", request)).notifyTime(this.getField("notify_time", request)).tradeNo(this.getField("trade_no", request)).build();
    }

    private String getField(String fieldName, HttpServletRequest request) {
        return new String(request.getParameter(fieldName).getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
    }

    private Boolean verifyResult(HttpServletRequest request) throws AlipayApiException {
        return AlipaySignature.rsaCheckV1(this.covertMap(request), (String)this.alipayProperties.getAlipayPublicKey(), (String)this.alipayProperties.getCharset(), (String)this.alipayProperties.getSigntype());
    }

    private Map<String, String> covertMap(HttpServletRequest request) {
        HashMap map = Maps.newHashMap();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            map.put(name, valueStr);
        }
        log.info("\u652f\u4ed8\u5b9d\u5f02\u6b65\u901a\u77e5\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)map));
        return map;
    }
}

