/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.thirdparty.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.thirdpart.facade.enums.PayTypeEnum;
import com.bxm.fossicker.thirdpart.facade.service.PayMethodAdapter;
import com.bxm.fossicker.thirdparty.model.vo.WxJsapiSignatureVO;
import com.bxm.fossicker.thirdparty.service.WxMenuService;
import com.bxm.fossicker.thirdparty.service.WxMpAuthService;
import com.bxm.fossicker.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.mp.api.WxMpConfigStorage;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"3-04 \u5fae\u4fe1\u76f8\u5173\u5916\u90e8\u63a5\u53e3"}, description="\u5fae\u4fe1\u76f8\u5173\u5916\u90e8\u63a5\u53e3")
@RestController
@RequestMapping(value={"thirdparty/public/wechat"})
public class WechatPublicController {
    private static final Logger log = LoggerFactory.getLogger(WechatPublicController.class);
    private final WxMpAuthService wxMpAuthService;
    private final WxMpMessageRouter wxMpMessageRouter;
    private final WxMpService wxMpService;
    private final WxMenuService wxMenuService;
    private final PayMethodAdapter payMethodAdapter;

    @Autowired
    public WechatPublicController(WxMpAuthService wxMpAuthService, WxMpMessageRouter wxMpMessageRouter, WxMpService wxMpService, WxMenuService wxMenuService, PayMethodAdapter payMethodAdapter) {
        this.wxMpAuthService = wxMpAuthService;
        this.wxMpMessageRouter = wxMpMessageRouter;
        this.wxMpService = wxMpService;
        this.wxMenuService = wxMenuService;
        this.payMethodAdapter = payMethodAdapter;
    }

    @ApiOperation(value="3-04-1 \u83b7\u53d6\u5fae\u4fe1js\u7b7e\u540d\u9a8c\u8bc1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="url", value="\u7b7e\u540d\u8ba4\u8bc1\u7684url", dataType="String", required=true)})
    @GetMapping(value={"/jssignature"})
    public ResponseJson<WxJsapiSignatureVO> getWxJsapiSignature(@RequestParam(value="url") String url) {
        return ResponseJson.ok((Object)this.wxMpAuthService.getWxJsapiSignature(url));
    }

    @RequestMapping(value={"/push"})
    public void eventHandler(HttpServletRequest request, HttpServletResponse response) throws IOException {
        WxMpXmlMessage inMessage;
        log.info("\u83b7\u53d6\u5fae\u4fe1\u63a8\u9001\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)request.getParameterMap()));
        String signature = request.getParameter("signature");
        String nonce = request.getParameter("nonce");
        String timestamp = request.getParameter("timestamp");
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        if (!this.wxMpService.checkSignature(timestamp, nonce, signature)) {
            log.error("\u6d88\u606f\u7b7e\u540d\u4e0d\u6b63\u786e");
            response.getWriter().println("\u975e\u6cd5\u8bf7\u6c42");
            return;
        }
        String echostr = request.getParameter("echostr");
        if (StringUtils.isNotBlank((CharSequence)echostr)) {
            log.error("\u9a8c\u8bc1\u7684\u8bf7\u6c42,\u56de\u8c03\u7684\u4fe1\u606f\u4e3a:{}", (Object)echostr);
            response.getWriter().println(echostr);
            return;
        }
        String encryptType = StringUtils.isBlank((CharSequence)request.getParameter("encrypt_type")) ? "raw" : request.getParameter("encrypt_type");
        WxMpConfigStorage wxMpConfigStorage = this.wxMpService.getWxMpConfigStorage();
        if ("raw".equals(encryptType)) {
            inMessage = WxMpXmlMessage.fromXml((InputStream)request.getInputStream());
        } else if ("aes".equals(encryptType)) {
            String msgSignature = request.getParameter("msg_signature");
            inMessage = WxMpXmlMessage.fromEncryptedXml((InputStream)request.getInputStream(), (WxMpConfigStorage)wxMpConfigStorage, (String)timestamp, (String)nonce, (String)msgSignature);
        } else {
            log.error("\u4e0d\u53ef\u8bc6\u522b\u7684\u52a0\u5bc6\u7c7b\u578b");
            response.getWriter().println("\u4e0d\u53ef\u8bc6\u522b\u7684\u52a0\u5bc6\u7c7b\u578b");
            return;
        }
        WxMpXmlOutMessage outMessage = this.wxMpMessageRouter.route(inMessage);
        if (outMessage != null) {
            log.info("\u4e1a\u52a1\u5904\u7406\u5b8c\u6210\u540e\u7684\u6570\u636e:{}", (Object)JSON.toJSONString((Object)outMessage));
            if ("raw".equals(encryptType)) {
                log.debug("\u660e\u6587\u4f20\u8f93,\u4e0d\u8fdb\u884c\u52a0\u5bc6");
                response.getWriter().write(outMessage.toXml());
                log.debug("\u8fd4\u56de\u7684response:{}", (Object)outMessage.toXml());
            } else if ("aes".equals(encryptType)) {
                log.debug("\u5bc6\u6587\u4f20\u8f93,\u8fdb\u884c\u52a0\u5bc6");
                response.getWriter().write(outMessage.toEncryptedXml(wxMpConfigStorage));
                log.debug("\u8fd4\u56de\u7684response:{}", (Object)outMessage.toEncryptedXml(wxMpConfigStorage));
            }
        }
    }

    @GetMapping(value={"/menu/add"})
    public ResponseJson addMenu() {
        this.wxMenuService.createMenu();
        return ResponseJson.ok();
    }

    @RequestMapping(value={"/cb/success"}, method={RequestMethod.POST})
    public String cbSuccess(@RequestBody String xml) {
        return this.payMethodAdapter.notifyPay(xml, PayTypeEnum.WX_PAY);
    }
}

