package com.bxm.fossicker.thirdpart.facade.dto;

import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Created by Gonzo on 2019-07-18.
 */
@Data
@Builder
@EqualsAndHashCode(callSuper = true)
public class WechatWithdrawDTO extends BaseWithdrawDTO {
    /**
     * 商户账号appid
     */
    private String mchAppId;


    private String mchId;

    /**
     * 设备信息
     * 微信支付分配的终端设备号
     */
    private String deviceInfo;

    /**
     * 商户订单号
     * 商户订单号，需保持唯一性
     * (只能是字母或者数字，不能包含有其他字符)
     */
    private String partnerTradeNo;

    /**
     * 企业付款成功，返回的微信付款单号
     */
    private String paymentNo;

    /**
     * 企业付款成功时间
     */
    private String paymentTime;

}
