package com.bxm.fossicker.thirdpart.facade.enums;

/**
 * @author zhaoyadong 2018/12/27 20:37
 * @desc
 */
public enum PayTypeEnum {

    WX_PAY((byte) 1, "WECHAT", "微信"),

    ALI_PAY((byte) 2, "ALIPAY", "支付宝"),

    WX_JS_API_PAY((byte) 3, "WECHAT_JS_API", "微信JS-API支付");

    private Byte type;

    private String name;

    private String desc;

    PayTypeEnum(Byte type, String name, String desc) {
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    public static String getNameByType(Byte type) {
        for (PayTypeEnum payTypeEnum : PayTypeEnum.values()) {
            if (payTypeEnum.getType().equals(type)) {
                return payTypeEnum.getName();
            }
        }
        return null;
    }

    public static PayTypeEnum getPayTypeEnum(String name) {
        for (PayTypeEnum payTypeEnum : PayTypeEnum.values()) {
            if (payTypeEnum.getName().equals(name)) {
                return payTypeEnum;
            }
        }
        return null;
    }

    public static PayTypeEnum getPayTypeEnum(Byte type) {
        for (PayTypeEnum payTypeEnum : PayTypeEnum.values()) {
            if (payTypeEnum.getType().equals(type)) {
                return payTypeEnum;
            }
        }
        return null;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
