package com.bxm.fossicker.thirdpart.facade.param;

import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;
import java.util.Map;

@Data
@Builder
public class UserPayOrderInfoContext {

    @Tolerate
    public UserPayOrderInfoContext() {
    }

    private Long id;

    @ApiModelProperty(value = "用户id")
    private Long userId;

    @ApiModelProperty(value = "订单编号")
    private String orderNo;

    @ApiModelProperty(value = "付款链接")
    private String link;

    @ApiModelProperty(value = "跳转链接")
    private String returnUrl;

    @ApiModelProperty(value = "客户端提现ip")
    private String clientIp;

    @ApiModelProperty(value = "1-微信支付 2-支付宝")
    private String payType;

    @ApiModelProperty(value = "支付金额")
    private BigDecimal money;

    @ApiModelProperty(value = "第三方订单号")
    private String tradeNo;

    @ApiModelProperty("请求微信授权数据的code")
    private String code;

    @ApiModelProperty(value = "执行过程中的参数map ", hidden = true)
    private Map<String, Object> paramMap = Maps.newHashMap();

    /**
     * 调用过程中添加参数
     * @param key   参数的键值
     * @param value 键值对应的值
     */
    public void addParam(String key, Object value) {
        this.paramMap.put(key, value);
    }

    /**
     * 获取消息传递的参数信息
     * @return 参数MAP
     */
    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    /**
     * 获取消息传递的参数信息
     * @return 参数MAP
     */
    public <T> T getParam(String key) {
        return (T) this.paramMap.get(key);
    }

    private static final long serialVersionUID = 1L;

}