package com.bxm.fossicker.thirdpart.facade.param;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * Created by Gonzo on 2019-07-17.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class WithdrawParam extends BaseBean {

    @ApiModelProperty(value = "发起提现的用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "用户申请提现金额，最少为1元", required = true, example = "1 12.03 11.19")
    private BigDecimal amount;

    @ApiModelProperty(value = "提现渠道类型，WECHAT：微信，ALIPAY：支付宝", required = true)
    private String withdrawChannel;

    @ApiModelProperty(value = "提现客户端类型，1 app提现 2 小程序提现", required = true)
    private Byte withdrawClientType;

    @ApiModelProperty(value = "提现账号", required = true)
    private String payAccount;

    @ApiModelProperty(value = "客户端设备号", required = true)
    private String equipment;

    @ApiModelProperty(value = "订单号", required = true)
    private String orderNo;

    @ApiModelProperty(value = "客户端提现ip",  required = true)
    private String clientIp;

    @Tolerate
    public WithdrawParam() {
    }

}
