package com.bxm.fossicker.thirdpart.facade.param;

import lombok.Data;

@Data
public class WxH5ContractParam {

    /**
     * 商户订单号
     */
    private String outTradeNo;




    /**
     * 商品描述
     */
    private String tradeOrderDesc;


    /**
     * 回调通知ur
     */
    private String notifyUrl;

    /**
     * 订单总金额，单位为分
     */
    private Integer totalFee;

    /**
     * 终端IP
     * APP和网页支付提交用户端ip,Native支付填调用微信支付API的机器IP.
     */
    private String spbillCreateIp;

    /**
     * 模板id
     * 协议模板id
     */
    private Integer planId;

    /**
     * 签约协议号
     */
    private String contractCode;

    /**
     * 请求序列号
     * 商户请求签约时的序列号，要求唯一性。序列号主要用于排序，不作为查询条件，纯数字,范围不能超过Int64的范围（9223372036854775807）。
     */
    private Long requestSerial;

    /**
     * 用户账户展示名称
     * 签约用户的名称,用于页面展示，参数值不支持UTF8非3字节编码的字符，例如表情符号，所以请勿传微信昵称到该字段
     */
    private String contractDisplayAccount;

    /**
     * 签约信息通知url
     */
    private String contractNotifyUrl;
}
