package com.bxm.fossicker.thirdpart.facade.service;

import com.bxm.fossicker.thirdpart.facade.dto.PaymentOrderDTO;
import com.bxm.fossicker.thirdpart.facade.enums.PayTypeEnum;
import com.bxm.fossicker.thirdpart.facade.param.UserPayOrderInfoContext;

/**
 * 支付代理接口
 *
 * @author liujia
 */
public interface PayMethodAdapter {

    /**
     * 创建订单，用于后续和回调进行匹配
     *
     * @param userPayOrderInfoContext 订单参数上下文
     * @return 创建的订单对象
     */
    <T extends PaymentOrderDTO> T create(UserPayOrderInfoContext userPayOrderInfoContext);

    /**
     * 支付回调
     *
     * @param data    回调参数
     * @param payType 回调的支付平台类型
     * @return 支付结果
     */
    String notifyPay(String data, PayTypeEnum payType);
}
